/*
 * Decompiled with CFR 0.152.
 */
package github.qbic.verticalslabs;

import github.qbic.verticalslabs.VerticalSlabBlock;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="verticalslabs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"verticalslabs");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"verticalslabs");
    public static final Map<Block, RegistryObject<Block>> VERTICAL_SLABS = new LinkedHashMap<Block, RegistryObject<Block>>();

    private static void registerVerticalSlab(String name, Block baseSlab) {
        RegistryObject block = BLOCKS.register(name + "_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseSlab).m_60999_()));
        ITEMS.register(name + "_vertical_slab", () -> new BlockItem((Block)block.get(), new Item.Properties()));
        VERTICAL_SLABS.put(baseSlab, (RegistryObject<Block>)block);
    }

    private static void registerVerticalWoodSlab(String name, Block baseSlab) {
        RegistryObject block = BLOCKS.register(name + "_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseSlab)));
        ITEMS.register(name + "_vertical_slab", () -> new BlockItem((Block)block.get(), new Item.Properties()));
        VERTICAL_SLABS.put(baseSlab, (RegistryObject<Block>)block);
    }

    @SubscribeEvent
    public static void onBuildCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            for (RegistryObject<Block> block : VERTICAL_SLABS.values()) {
                event.m_246326_((ItemLike)((Block)block.get()).m_5456_());
            }
        }
    }

    static {
        ModBlocks.registerVerticalWoodSlab("oak", Blocks.f_50398_);
        ModBlocks.registerVerticalWoodSlab("spruce", Blocks.f_50399_);
        ModBlocks.registerVerticalWoodSlab("birch", Blocks.f_50400_);
        ModBlocks.registerVerticalWoodSlab("jungle", Blocks.f_50401_);
        ModBlocks.registerVerticalWoodSlab("acacia", Blocks.f_50402_);
        ModBlocks.registerVerticalWoodSlab("dark_oak", Blocks.f_50403_);
        ModBlocks.registerVerticalWoodSlab("mangrove", Blocks.f_220851_);
        ModBlocks.registerVerticalWoodSlab("cherry", Blocks.f_271301_);
        ModBlocks.registerVerticalWoodSlab("bamboo", Blocks.f_244004_);
        ModBlocks.registerVerticalWoodSlab("crimson", Blocks.f_50657_);
        ModBlocks.registerVerticalWoodSlab("warped", Blocks.f_50658_);
        ModBlocks.registerVerticalSlab("stone", Blocks.f_50404_);
        ModBlocks.registerVerticalSlab("brick", Blocks.f_50410_);
        ModBlocks.registerVerticalSlab("cobblestone", Blocks.f_50409_);
        ModBlocks.registerVerticalSlab("granite", Blocks.f_50651_);
        ModBlocks.registerVerticalSlab("diorite", Blocks.f_50603_);
        ModBlocks.registerVerticalSlab("andesite", Blocks.f_50600_);
        ModBlocks.registerVerticalSlab("blackstone", Blocks.f_50733_);
        ModBlocks.registerVerticalSlab("polished_blackstone", Blocks.f_50708_);
    }
}

