/*
 * Decompiled with CFR 0.152.
 */
package github.qbic.verticalslabs;

import github.qbic.verticalslabs.VerticalSlabType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.m_61587_((String)"type", VerticalSlabType.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public VerticalSlabBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.SINGLE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(TYPE) == VerticalSlabType.DOUBLE) {
            return Shapes.m_83144_();
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        return switch (dir) {
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
            case Direction.EAST -> Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
            default -> Shapes.m_83144_();
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing;
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        BlockState existing = level.m_8055_(pos);
        Direction face = ctx.m_43719_();
        if (existing.m_60734_() == this && existing.m_61143_(TYPE) == VerticalSlabType.SINGLE) {
            if (existing.m_61143_((Property)FACING) == face.m_122424_()) {
                return (BlockState)existing.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE));
            }
            return null;
        }
        if (face.m_122434_().m_122479_()) {
            facing = face.m_122424_();
        } else {
            Vec3 hit = ctx.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)pos));
            Direction playerFacing = ctx.m_8125_();
            facing = switch (playerFacing) {
                case Direction.EAST, Direction.WEST -> {
                    if (hit.f_82479_ < 0.5) {
                        yield Direction.WEST;
                    }
                    yield Direction.EAST;
                }
                case Direction.SOUTH, Direction.NORTH -> {
                    if (hit.f_82481_ < 0.5) {
                        yield Direction.NORTH;
                    }
                    yield Direction.SOUTH;
                }
                default -> Direction.NORTH;
            };
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.SINGLE));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        return state.m_61143_(TYPE) == VerticalSlabType.SINGLE && ctx.m_43722_().m_41720_() == this.m_5456_() && ctx.m_43719_().m_122424_() == state.m_61143_((Property)FACING);
    }
}

