/*
 * Decompiled with CFR 0.152.
 */
package github.qbic.verticalslabs.datagen;

import github.qbic.verticalslabs.ModBlocks;
import github.qbic.verticalslabs.VerticalSlabBlock;
import github.qbic.verticalslabs.VerticalSlabType;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "verticalslabs", helper);
    }

    protected void registerStatesAndModels() {
        for (Map.Entry<Block, RegistryObject<Block>> entry : ModBlocks.VERTICAL_SLABS.entrySet()) {
            ResourceLocation sideTex;
            Block baseSlab = entry.getKey();
            Block verticalSlab = (Block)entry.getValue().get();
            ResourceLocation slabId = ForgeRegistries.BLOCKS.getKey((Object)verticalSlab);
            ResourceLocation baseId = ForgeRegistries.BLOCKS.getKey((Object)baseSlab);
            String name = slabId.m_135815_();
            String texture = baseId.m_135827_() + ":block/" + baseId.m_135815_().replace("_slab", "");
            String textureName = baseId.m_135815_().replace("_slab", "");
            if (baseId.m_135815_().contains("_planks")) {
                textureName = baseId.m_135815_().replace("_planks", "");
            }
            String fullBlockTextureName = this.getFullBlockTextureName(textureName);
            ResourceLocation topTex = sideTex = new ResourceLocation("minecraft", "block/" + fullBlockTextureName);
            ModelBuilder single = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + "_single")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("all", sideTex.toString())).texture("particle", sideTex.toString())).element().from(0.0f, 0.0f, 0.0f).to(8.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#all").end().face(Direction.SOUTH).texture("#all").end().face(Direction.EAST).texture("#all").end().face(Direction.WEST).texture("#all").end().face(Direction.UP).texture("#all").end().face(Direction.DOWN).texture("#all").end().end();
            ModelBuilder dbl = this.models().cubeAll(name + "_double", sideTex);
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(verticalSlab).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.SINGLE)).with((Property)VerticalSlabBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)single).rotationY(90).addModel()).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.SINGLE)).with((Property)VerticalSlabBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)single).rotationY(180).addModel()).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.SINGLE)).with((Property)VerticalSlabBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)single).rotationY(270).addModel()).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.SINGLE)).with((Property)VerticalSlabBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)single).rotationY(0).addModel()).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE)).modelForState().modelFile((ModelFile)dbl).addModel();
            ((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)single);
        }
    }

    private String getFullBlockTextureName(String slabTextureName) {
        switch (slabTextureName) {
            case "oak": {
                return "oak_planks";
            }
            case "spruce": {
                return "spruce_planks";
            }
            case "birch": {
                return "birch_planks";
            }
            case "jungle": {
                return "jungle_planks";
            }
            case "acacia": {
                return "acacia_planks";
            }
            case "dark_oak": {
                return "dark_oak_planks";
            }
            case "crimson": {
                return "crimson_planks";
            }
            case "warped": {
                return "warped_planks";
            }
            case "cherry": {
                return "cherry_planks";
            }
            case "bamboo": {
                return "bamboo_planks";
            }
            case "mangrove": {
                return "mangrove_planks";
            }
            case "brick": {
                return "bricks";
            }
        }
        return slabTextureName;
    }
}

