package fr.estecka.variantscit;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.class_10191;
import net.minecraft.class_10192;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;

public class EquippableCache
{
	/**
	 * Key 1: Maps original components to a list of their known variations.
	 * Key 2: Maps variant ID to the modified copy of the component.
	 */
	private final WeakHashMap<class_10192, Map<class_2960, class_10192>> cache = new WeakHashMap<>();

	public void Clear(){
		this.cache.clear();
	}

	public class_10192 GetWithAssetId(class_10192 original, class_2960 id){
		return this.cache
			.computeIfAbsent(original, _0->new HashMap<>())
			.computeIfAbsent(id, _0->CopyWithAssetId(original, id))
			;
	}

	static private class_10192 CopyWithAssetId(class_10192 original, class_2960 id){
		return new class_10192(
			original.comp_3174(),
			original.comp_3175(),
			Optional.of(class_5321.method_29179(class_10191.field_55214, id)),
			original.comp_3306(),
			original.comp_3177(),
			original.comp_3178(),
			original.comp_3213(),
			original.comp_3214(),
			original.comp_3523()
		);
	}

	/**
	 * Mixin injection.
	 * See: {@link fr.estecka.variantscit.mixin.FeatureRendererMixins}
	 */
	public Object GetEquipableVariant(class_1799 stack, class_9331<?> type, Operation<?> originalOp){
		Object original = originalOp.call(stack, type);

		if (type != class_9334.field_54196
		|| !(original instanceof class_10192 equipable) )
		{
			return original;
		}

		final IItemModelProvider module = VariantsCitMod.GetEquipmentModule(stack.method_7909());
		class_2960 assetId;

		if (module == null || (assetId=module.GetModelForItem(stack)) == null)
			return original;
		else
			return GetWithAssetId(equipable, assetId);
	}
}
