package fr.estecka.variantscit;

import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.api.IVariantManager;

public record VariantLibrary(
	@Nullable class_2960 fallbackModel,
	Map<class_2960, class_2960> variantModels,
	Map<String, class_2960> specialModels
)
implements IVariantManager
{
	@Override
	public boolean HasVariantModel(class_2960 variant){
		return this.variantModels.containsKey(variant);
	}

	@Override
	public @Nullable class_2960 GetVariantModel(class_2960 variant){
		if (variant == null)
			return null;
		else
			return this.variantModels.getOrDefault(variant, this.fallbackModel);
	}

	@Override
	public @Nullable class_2960 GetSpecialModel(String key){
		return this.specialModels.get(key);
	}

	public int GetVariantCount(){
		return this.variantModels.size();
	}

	public boolean isEmpty(){
		return this.variantModels.isEmpty()
		    && this.specialModels.isEmpty()
		    && this.fallbackModel == null
		    ;
	}
}
