package fr.estecka.variantscit;

import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_9334;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.reload.ModuleLoader;
import fr.estecka.variantscit.modules.*;


public class VariantsCitMod
implements ClientModInitializer
{
	static public final String MODID = "variants-cit";
	public static final Logger LOGGER = LoggerFactory.getLogger(MODID);

	static public int reloadcount = 0;
	static public final EquippableCache EQUIPABLES = new EquippableCache();
	static private Map<class_1792, IItemModelProvider> ITEM_MODULES  = new HashMap<>();
	static private Map<class_1792, IItemModelProvider> EQUIP_MODULES = new HashMap<>();

	static public @Nullable IItemModelProvider GetItemModule(class_1792 itemType){
		return ITEM_MODULES.get(itemType);
	}
	static public @Nullable IItemModelProvider GetEquipmentModule(class_1792 itemType){
		return EQUIP_MODULES.get(itemType);
	}

	@Override
	public void onInitializeClient(){
		ModuleRegistry.Register(class_2960.method_60656("axolotl_variant"), AxolotlBucketModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("block_entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49611));
		ModuleRegistry.Register(class_2960.method_60656("bucket_entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49610));
		ModuleRegistry.Register(class_2960.method_60656("component_data"), ComponentDataModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("component_format"), MultiComponentFormatModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("custom_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49628));
		ModuleRegistry.Register(class_2960.method_60656("custom_name"), CustomNameModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("durability"), DurabilityModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("enchantment"), EnchantmentModule.CreateCodec(class_9334.field_49633));
		ModuleRegistry.Register(class_2960.method_60656("entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49609));
		ModuleRegistry.Register(class_2960.method_60656("instrument"), new GoatHornModule());
		ModuleRegistry.Register(class_2960.method_60656("item_count"), ItemCountModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("jukebox_playable"), new MusicDiscModule());
		ModuleRegistry.Register(class_2960.method_60656("painting_variant"), new PaintingVariantModule());
		ModuleRegistry.Register(class_2960.method_60656("potion_effect"), new PotionEffectModule());
		ModuleRegistry.Register(class_2960.method_60656("potion_type"), new PotionTypeModule());
		ModuleRegistry.Register(class_2960.method_60656("stored_enchantment"), EnchantmentModule.CreateCodec(class_9334.field_49643));
		ModuleRegistry.Register(class_2960.method_60656("stored_enchantments"), MapCodec.unit(() -> {
			LOGGER.warn("Module name `stored_enchantments` (plural) is being deprecated. use `stored_enchantment` (singular) instead.");
			return new EnchantmentModule(class_9334.field_49643, Map.of(), Optional.empty());
		}));
		ModuleRegistry.Register(class_2960.method_60656("trim"), new TrimModule());
		ModuleRegistry.Register(class_2960.method_60656("trim_pattern"), new TrimPatternModule());
		ModuleRegistry.Register(class_2960.method_60656("trim_material"), new TrimPatternModule());
	}

	static public void OnResourceReload(ModuleLoader.Result result){
		++reloadcount;
		EQUIPABLES.Clear();
		ITEM_MODULES  = result.itemModules;
		EQUIP_MODULES = result.equipModules;
	}

}
