package fr.estecka.variantscit.reload;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import fr.estecka.variantscit.VariantLibrary;

public class EquipVariantAggregator
extends AVariantAggregator
{
	@Override
	public VariantLibrary CreateLibrary(ModuleDefinition definition, class_3300 manager){
		Map<class_2960,class_2960> allVariants = new HashMap<>();
		Map<String,class_2960> allSpecials = new HashMap<>();

		final String prefix = definition.modelPrefix();
		final var specials = new HashMap<>(definition.specialModels());
		definition.fallbackModel().ifPresent(fallback -> specials.put(null, fallback));

		// Variants from equipments
		{
			var varItems  = FindVariants(manager, "equipment", prefix, ".json");
			var speItems  = FindSpecials(manager, "equipment", specials, ".json");
			allVariants.putAll(varItems);
			allSpecials.putAll(speItems);
		}

		allSpecials.remove(null);
		return new VariantLibrary(
			definition.fallbackModel().orElse(null),
			allVariants,
			allSpecials
		);
	}

}
