/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.transforms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.format.IStringTransform;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import org.jetbrains.annotations.Nullable;

public record CharRemapTransform(Char2ObjectMap<@Nullable Character> map) implements IStringTransform
{
    public static final MapCodec<CharRemapTransform> MAPCODEC = StringCharmap.MAPCODEC.xmap(StringCharmap::ToMap, StringCharmap::FromMap).xmap(CharRemapTransform::new, CharRemapTransform::map);

    @Override
    public String apply(String original) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char inChar = original.charAt(i);
            Character outChar = (Character)this.map.get(inChar);
            if (outChar != null) {
                result.append(outChar);
                continue;
            }
            if (this.map.containsKey(inChar)) continue;
            result.append(inChar);
        }
        return result.toString();
    }

    private record StringCharmap(String source, String destination) {
        public static final MapCodec<StringCharmap> MAPCODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("source").forGetter(StringCharmap::source), (App)Codec.STRING.fieldOf("destination").forGetter(StringCharmap::destination)).apply((Applicative)builder, StringCharmap::new));

        public static StringCharmap FromMap(Char2ObjectMap<@Nullable Character> map) {
            StringBuilder src = new StringBuilder();
            StringBuilder dst = new StringBuilder();
            for (Char2ObjectMap.Entry entry : map.char2ObjectEntrySet()) {
                char key = entry.getCharKey();
                Character value = (Character)entry.getValue();
                if (value == null) continue;
                src.append(key);
                dst.append(value);
            }
            for (Char2ObjectMap.Entry entry : map.char2ObjectEntrySet()) {
                if (entry.getValue() != null) continue;
                src.append(entry.getCharKey());
            }
            return new StringCharmap(src.toString(), dst.toString());
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Char2ObjectMap<@Nullable Character> ToMap() {
            @Nullable Char2ObjectArrayMap map = new Char2ObjectArrayMap();
            for (int i = 0; i < this.source.length(); ++i) {
                char key = this.source.charAt(i);
                if (i < this.destination.length()) {
                    map.put(key, (Object)Character.valueOf(this.destination.charAt(i)));
                    continue;
                }
                map.put(key, null);
            }
            return map;
        }
    }
}

