package fr.estecka.variantscit.mixin;

import java.util.function.Supplier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_763;
import net.minecraft.class_918;
import fr.estecka.variantscit.IItemModelProvider;
import fr.estecka.variantscit.VariantsCitMod;

@Mixin(class_918.class)
@Environment(EnvType.CLIENT)
public class ItemRendererMixin
{
	@Shadow private @Final class_1092 bakedModelManager;

	@Unique
	private class_1087	GetVariantModel(class_1092 modelManager, class_1799 stack, Supplier<class_1087> original)
	{
		final IItemModelProvider module = VariantsCitMod.GetModule(stack.method_7909());
		class_1091 modelId;

		if (module == null || (modelId=module.GetModelForItem(stack)) == null)
			return original.get();

		class_1087 model = modelManager.method_4742(modelId);
		return (model != null) ? model : modelManager.method_4744();
	}

	// Most items
	@WrapOperation( method="getModel", require=1, at=@At( value="INVOKE", target="net/minecraft/client/render/item/ItemModels.getModel (Lnet/minecraft/item/ItemStack;)Lnet/minecraft/client/render/model/BakedModel;") )
	private class_1087	GetItemStackModel(class_763 models, class_1799 stack, Operation<class_1087> original) {
		if (stack.method_31574(class_1802.field_8547))
			return original.call(models, stack);
		else
			return GetVariantModel(bakedModelManager, stack, ()->original.call(models, stack));
	}

	// Trident and Spyglass
	@WrapOperation(
		// Why are there so many different overloads of renderItem ?!?
		method="renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;Z)V",
		require=2, at=@At( value="INVOKE", target="net/minecraft/client/render/model/BakedModelManager.getModel (Lnet/minecraft/client/util/ModelIdentifier;)Lnet/minecraft/client/render/model/BakedModel;")
	)
	private class_1087	GetIdentifiedModel(class_1092 models, class_1091 id, Operation<class_1087> original, class_1799 stack) {
		return GetVariantModel(models, stack, ()->original.call(models, id));
	}

}
