package fr.estecka.variantscit.modules;

import java.util.stream.Stream;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.format.properties.IStringProperty;

abstract class ASimpleMultiComponentCachingModule
extends AMultiComponentCachingModule
{
	protected ASimpleMultiComponentCachingModule(boolean debug, Stream<IStringProperty> properties){
		super(debug, properties);
	}

	public abstract @Nullable class_2960 RecomputeItemVariant(class_1799 stack);

	@Override
	public @Nullable class_1091 RecomputeItemModel(class_1799 stack, IVariantManager library) {
		class_2960 variant = this.RecomputeItemVariant(stack);
		if (debug)
			VariantsCitMod.LOGGER.info("[ASimpleMultiComponent] Variant Id: {}", variant);
		return library.GetVariantModel(variant);
	}
}
