package fr.estecka.variantscit.reload;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import fr.estecka.variantscit.VariantLibrary;

public abstract class AVariantAggregator
{
	public abstract VariantLibrary CreateLibrary(ModuleDefinition definition, class_3300 manager);

	/**
	 * Finds all resources of a given type, whose id start with the given prefix.
	 * @param rootDirectory The type of the resources to look for.
	 * @return Maps the variant ID to its corresponding model ID
	 */
	static protected Map<class_2960,class_2960> FindVariants(class_3300 manager, String rootDirectory, String modelPrefix, String suffix){
		Map<class_2960, class_2960> results = new HashMap<>();

		String fullPrefix = rootDirectory+'/'+modelPrefix;
		String directory = fullPrefix.substring(0, fullPrefix.lastIndexOf('/'));
		for (class_2960 fileId : manager.method_14488(directory, id -> id.method_12832().startsWith(fullPrefix) && id.method_12832().endsWith(suffix)).keySet())
		{
			String namespace = fileId.method_12836();
			String assetName, variantName;
			assetName = fileId.method_12832();
			assetName = assetName.substring((rootDirectory+'/').length(), assetName.length()-suffix.length());
			variantName = assetName.substring(modelPrefix.length());

			results.put(
				class_2960.method_60655(namespace, variantName),
				class_2960.method_60655(namespace, assetName)
			);
		}

		return results;
	}

	/**
	 * Finds which of the requested model/texture IDs are actually available.
	 * @return The model/texture IDs
	 */
	static protected HashMap<String,class_2960> FindSpecials(class_3300 manager, String rootDirectory, Map<String,class_2960> requested, String suffix){
		Set<class_2960> valid = new HashSet<>();

		// ResourceId to ModelId
		Map<class_2960, class_2960> resourceIds = requested.values().stream().collect(Collectors.toMap(
			id -> id.method_45138(rootDirectory+'/').method_48331(suffix),
			id -> id
		));
		for (class_2960 fileId : manager.method_14488(rootDirectory, id->resourceIds.keySet().contains(id)).keySet())
			valid.add(resourceIds.get(fileId));

		var result = new HashMap<>(requested);
		result.entrySet().removeIf(e -> !valid.contains(e.getValue()));
		return result;
	}

}
