/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.reload.EModuleContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public record ModuleDefinition(class_2960 type, List<EModuleContext> contexts, Optional<List<class_2960>> targets, int priority, String modelPrefix, boolean itemGen, Optional<class_2960> modelParent, Optional<class_2960> fallbackModel, Map<String, class_2960> specialModels) {
    public static final MapCodec<ModuleDefinition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2960.field_25139.fieldOf("type").forGetter(ModuleDefinition::type), (App)CodecUtil.OneOrMany(EModuleContext.CODEC).optionalFieldOf("context", List.of(EModuleContext.ITEM_MODEL)).forGetter(ModuleDefinition::contexts), (App)CodecUtil.OneOrMany(class_2960.field_25139).optionalFieldOf("items").forGetter(ModuleDefinition::targets), (App)Codec.INT.fieldOf("priority").orElse((Object)0).forGetter(ModuleDefinition::priority), (App)Codec.STRING.validate(ModuleDefinition::ValidatePath).fieldOf("modelPrefix").forGetter(ModuleDefinition::modelPrefix), (App)Codec.BOOL.fieldOf("itemsFromModels").orElse((Object)true).forGetter(ModuleDefinition::itemGen), (App)class_2960.field_25139.optionalFieldOf("modelParent").forGetter(ModuleDefinition::fallbackModel), (App)class_2960.field_25139.validate(ModuleDefinition::UnItemify).optionalFieldOf("fallback").forGetter(ModuleDefinition::fallbackModel), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_2960.field_25139.validate(ModuleDefinition::UnItemify)).optionalFieldOf("special", (Object)ImmutableMap.of()).forGetter(ModuleDefinition::specialModels)).apply((Applicative)builder, ModuleDefinition::new));

    private static String UnItemify(String modelPrefix) {
        if (modelPrefix.startsWith("item/")) {
            modelPrefix = modelPrefix.substring("item/".length());
        }
        return modelPrefix;
    }

    private static DataResult<class_2960> UnItemify(class_2960 original) {
        return DataResult.success((Object)class_2960.method_60655((String)original.method_12836(), (String)ModuleDefinition.UnItemify(original.method_12832())));
    }

    public static DataResult<String> ValidatePath(String path) {
        if (class_2960.method_20208((String)path)) {
            return DataResult.success((Object)ModuleDefinition.UnItemify(path));
        }
        return DataResult.error(() -> "Invalid character in path: " + path);
    }
}

