package fr.estecka.variantscit.modules;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.format.properties.IntegerComponentProperty;

public class DurabilityModule
extends AMultiComponentCachingModule
{
	static public final MapCodec<DurabilityModule> CODEC = RecordCodecBuilder.mapCodec(builder->builder
		.group(
			Codec.BOOL.optionalFieldOf("debug", false).forGetter(o->o.debug),
			CodecUtil.IDENTIFIER_NAMESPACE.optionalFieldOf("namespace", "minecraft").forGetter(o->o.namespace),
			class_5699.field_33441.optionalFieldOf("scale").forGetter(o->o.scale)
		)
		.apply(builder, DurabilityModule::new)
	);

	private final String namespace;
	private final Optional<Integer> scale;

	public DurabilityModule (boolean debug, String namespace, Optional<Integer> scale){
		super(debug, Stream.of(IntegerComponentProperty.DAMAGE, IntegerComponentProperty.MAX_DAMAGE));
		this.namespace = namespace;
		this.scale = scale;
	}

	@Override
	public @Nullable class_2960 RecomputeItemModel(class_1799 stack, IVariantManager library) {
		Integer max = stack.method_57824(class_9334.field_50072);
		if (max == null)
			return null;

		int damage = stack.method_57824(class_9334.field_49629);
		int durability = Math.clamp(max - damage, 0, max);

		if (scale.isPresent()){
			durability *= scale.get();
			durability += max-1; // Round up when dividing
			durability /= max;
			max = scale.get();
		}

		for (int i=durability; i<=max; ++i) {
			class_2960 variantId = class_2960.method_60655(namespace, String.valueOf(i));
			if (library.HasVariantModel(variantId))
				return library.GetVariantModel(variantId);
		}

		return null;
	}
}
