package fr.estecka.variantscit.modules;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.api.IVariantManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ItemCountModule
implements ICitModule
{
	static public final MapCodec<ItemCountModule> CODEC = RecordCodecBuilder.mapCodec(builder->builder
		.group(
			CodecUtil.IDENTIFIER_NAMESPACE.optionalFieldOf("namespace", "minecraft").forGetter(o->o.namespace)
		)
		.apply(builder, ItemCountModule::new)
	);

	private final Int2ObjectMap<class_2960> cache = new Int2ObjectOpenHashMap<>();
	private final String namespace;

	public ItemCountModule(String namespace){
		this.namespace = namespace;
	}

	@Override
	public class_2960 GetItemModel(class_1799 stack, IVariantManager library){
		final int count = stack.method_7947();
		if (cache.containsKey(count))
			return cache.get(count);

		class_2960 result = null;
		for (int c=count; c >= 0; --c){
			class_2960 variant = class_2960.method_60655(namespace, String.valueOf(c));
			if (library.HasVariantModel(variant)){
				result = library.GetVariantModel(variant);
				break;
			}
		}

		cache.put(count, result);
		return result;
	}
}
