/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.VariantsCitMod;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class NbtPath {
    public static final Codec<NbtPath> CODEC = Codec.STRING.comapFlatMap(NbtPath::Parse, NbtPath::toString);
    public static final NbtPath IDENTITY = new NbtPath(new Token[0]);
    @Deprecated
    public static final Codec<NbtPath> DOT_SEPARATED_CODEC = Codec.STRING.comapFlatMap(NbtPath::DotSeparatedPath, NbtPath::toString).validate(_0 -> {
        VariantsCitMod.LOGGER.warn("The value of `nbtPath` Uses an obsolete path format. Please add a `.` at the start of the path.");
        return DataResult.success((Object)_0);
    });
    @Deprecated
    public static final Codec<NbtPath> NBTKEY_CODEC = Codec.STRING.xmap(s -> new NbtPath(new Token[]{new MapKey((String)s)}), NbtPath::toString).validate(_0 -> {
        VariantsCitMod.LOGGER.warn("The parameter `nbtKey` is being deprecated. Use `nbtPath` instead.");
        return DataResult.success((Object)_0);
    });
    private final Token[] tokens;

    private NbtPath(Token[] tokens) {
        this.tokens = tokens;
    }

    private NbtPath(List<Token> tokens) {
        this.tokens = (Token[])tokens.toArray(Token[]::new);
    }

    @Nullable
    public class_2520 Resolve(class_2520 nbt) {
        for (Token tk : this.tokens) {
            if ((nbt = tk.Resolve(nbt)) != null) continue;
            return null;
        }
        return nbt;
    }

    @Deprecated
    public static DataResult<NbtPath> DotSeparatedPath(String rawPath) throws IllegalStateException {
        if (rawPath.isEmpty()) {
            return DataResult.success((Object)new NbtPath(new Token[0]));
        }
        String[] names = rawPath.split("\\.");
        Token[] tokens = new Token[names.length];
        for (int i = 0; i < names.length; ++i) {
            tokens[i] = new MapKey(names[i]);
        }
        return DataResult.success((Object)new NbtPath(tokens));
    }

    public static DataResult<NbtPath> Parse(String input) {
        Function[] parsers = new Function[]{MapKey::Next, ArrayIndex::Next, MapIndex::Next};
        ArrayList<Token> tokens = new ArrayList<Token>();
        String remainder = input;
        while (!remainder.isEmpty()) {
            DataResult result = null;
            for (int i = 0; i < parsers.length && result == null; ++i) {
                result = (DataResult)parsers[i].apply(remainder);
            }
            if (result == null) {
                String rem = remainder;
                result = DataResult.error(() -> "Invalid character here -> " + rem);
            }
            if (result.isError()) {
                return result.map(_0 -> new NbtPath(tokens)).mapError(err -> "Invalid token in path: " + input + "\n" + err);
            }
            Parsed parsed = (Parsed)result.getOrThrow();
            tokens.add(parsed.token);
            remainder = parsed.remainder;
        }
        return DataResult.success((Object)new NbtPath(tokens));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Token tk : this.tokens) {
            builder.append(tk.toString());
        }
        return builder.toString();
    }

    private static interface Token {
        @Nullable
        public class_2520 Resolve(class_2520 var1);
    }

    private record MapKey(String name) implements Token
    {
        private static final char QUOTE = '\'';
        private static final char ESCAPE = '\\';

        @Override
        public class_2520 Resolve(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                return compound.method_10580(this.name);
            }
            return null;
        }

        @Override
        public String toString() {
            return ".'" + this.name + "'";
        }

        private static DataResult<Parsed> Next(String input) {
            if (input.length() < 2 || input.charAt(0) != '.') {
                return null;
            }
            Object result = "";
            boolean openQuotes = false;
            boolean isEscaping = false;
            int end = 1;
            if (input.charAt(1) == '\'') {
                openQuotes = true;
                ++end;
            }
            while (end < input.length()) {
                char c = input.charAt(end);
                if (isEscaping) {
                    result = (String)result + c;
                    isEscaping = false;
                } else if (c == '\\') {
                    isEscaping = true;
                } else {
                    if (openQuotes && c == '\'') {
                        openQuotes = false;
                        ++end;
                        break;
                    }
                    if (!openQuotes && !MapKey.IsCharValid(c)) break;
                    result = (String)result + c;
                }
                ++end;
            }
            if (end <= 1) {
                return DataResult.error(() -> "Missing keyname after dot -> " + input + "\nIf the key is intentionally empty, quote it. ( Write .'' )");
            }
            if (openQuotes) {
                return DataResult.error(() -> "Unclosed quote in keyname -> " + input);
            }
            if (isEscaping) {
                return DataResult.error(() -> "Escape character at the end of input -> " + input);
            }
            return DataResult.success((Object)new Parsed(new MapKey((String)result), input.substring(end)));
        }

        private static boolean IsCharValid(char c) {
            return 'A' <= c && c <= 'Z' || class_2960.method_12831((char)c) && c != '.';
        }
    }

    private record Parsed(Token token, String remainder) {
    }

    private record MapIndex(int index) implements Token
    {
        @Override
        public class_2520 Resolve(class_2520 nbt) {
            if (!(nbt instanceof class_2487)) {
                return null;
            }
            class_2487 compound = (class_2487)nbt;
            int size = compound.method_10546();
            if (this.index < -size || size <= this.index) {
                return null;
            }
            int i = this.index;
            if (i < 0) {
                i += size;
            }
            String key = null;
            for (String k : compound.method_10541()) {
                if (i-- > 0) continue;
                key = k;
                break;
            }
            if (key == null) {
                return null;
            }
            class_2487 result = new class_2487();
            result.method_10582("key", key);
            result.method_10566("value", compound.method_10580(key));
            return result;
        }

        private static DataResult<Parsed> Next(String input) {
            int index;
            if (input.length() < 3 || input.charAt(0) != '{') {
                return null;
            }
            int end = input.indexOf(125);
            if (end < 0) {
                return DataResult.error(() -> "Empty map index here -> " + input);
            }
            try {
                index = Integer.parseUnsignedInt(input.substring(1, end));
            }
            catch (NumberFormatException e) {
                return DataResult.error(() -> "Map index is not a number -> " + input);
            }
            return DataResult.success((Object)new Parsed(new MapIndex(index), input.substring(end + 1)));
        }

        @Override
        public String toString() {
            return "{" + this.index + "}";
        }
    }

    private record ArrayIndex(int index) implements Token
    {
        @Override
        public class_2520 Resolve(class_2520 nbt) {
            if (!(nbt instanceof class_2483)) {
                return null;
            }
            class_2483 list = (class_2483)nbt;
            int size = list.size();
            if (this.index < -size || size <= this.index) {
                return null;
            }
            if (this.index >= 0) {
                return (class_2520)list.get(this.index);
            }
            return (class_2520)list.get(size + this.index);
        }

        @Override
        public String toString() {
            return "[" + this.index + "]";
        }

        private static DataResult<Parsed> Next(String input) {
            int index;
            if (input.length() < 3 || input.charAt(0) != '[') {
                return null;
            }
            int end = input.indexOf(93);
            if (end < 0) {
                return DataResult.error(() -> "Empty array index here -> " + input);
            }
            try {
                index = Integer.parseUnsignedInt(input.substring(1, end));
            }
            catch (NumberFormatException e) {
                return DataResult.error(() -> "Array indx is not a number -> " + input);
            }
            return DataResult.success((Object)new Parsed(new ArrayIndex(index), input.substring(end + 1)));
        }
    }
}

