/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.format.Substitution;
import fr.estecka.variantscit.format.properties.AxolotlVariantProperty;
import fr.estecka.variantscit.format.properties.EntityAgeMapProperty;
import fr.estecka.variantscit.format.properties.IStringProperty;
import fr.estecka.variantscit.modules.impl.FallbackModule;
import fr.estecka.variantscit.modules.impl.MultiComponentFormatModule;
import java.util.HashMap;

public final class AxolotlBucketModule {
    public static final MapCodec<ICitModule> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(o -> false), (App)CodecUtil.IDENTIFIER_PATH.optionalFieldOf("adultSuffix", (Object)"").forGetter(o -> ""), (App)CodecUtil.IDENTIFIER_PATH.optionalFieldOf("babySuffix", (Object)"_baby").forGetter(o -> "")).apply((Applicative)builder, AxolotlBucketModule::Create));
    private static final Substitution agedFormat = (Substitution)Substitution.Parse("${variant}${age}").getOrThrow();
    private static final HashMap<String, IStringProperty> ageInvariantVariables = new HashMap();

    public static ICitModule Create(boolean debug, String adult, String baby) {
        ICitModule result = AxolotlBucketModule.CreateAgeInvariantModule(debug, adult);
        if (!adult.equals(baby)) {
            result = new FallbackModule(AxolotlBucketModule.CreateAgedModule(debug, adult, baby), result);
        }
        return result;
    }

    public static MultiComponentFormatModule CreateAgedModule(boolean debug, String adult, String baby) {
        HashMap<String, IStringProperty> variables = new HashMap<String, IStringProperty>();
        variables.put("variant", AxolotlVariantProperty.UNIT);
        variables.put("age", new EntityAgeMapProperty(adult, baby));
        return new MultiComponentFormatModule(debug, agedFormat, variables);
    }

    public static MultiComponentFormatModule CreateAgeInvariantModule(boolean debug, String suffix) {
        return new MultiComponentFormatModule(debug, (Substitution)Substitution.Parse("${variant}" + suffix).getOrThrow(), ageInvariantVariables);
    }

    static {
        ageInvariantVariables.put("variant", AxolotlVariantProperty.UNIT);
    }
}

