/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.estecka.variantscit.ModuleRegistry;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.modules.BakedModule;
import fr.estecka.variantscit.modules.libraries.VariantLibrary;
import fr.estecka.variantscit.reload.ModelAggregator;
import fr.estecka.variantscit.reload.ModuleDefinition;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class ModuleLoader
implements PreparableModelLoadingPlugin.DataLoader<Result> {
    public CompletableFuture<Result> load(class_3300 resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> ModuleLoader.ReloadModules(resourceManager), executor);
    }

    private static Result ReloadModules(class_3300 manager) {
        Result result = new Result();
        HashMap<class_2960, class_3298> resources = new HashMap<class_2960, class_3298>();
        resources.putAll(manager.method_14488("variant-cits/item", id -> id.method_12832().endsWith(".json")));
        ModuleLoader.Warn(resources);
        resources.putAll(manager.method_14488("variants-cit/item", id -> id.method_12832().endsWith(".json")));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                class_2960 moduleId = ModuleLoader.ModuleIdFromResourceId((class_2960)entry.getKey());
                ProtoModule prototype = (ProtoModule)ModuleLoader.DefinitionFromResource((class_3298)entry.getValue()).getOrThrow();
                Set targets = prototype.definition.targets().map(ModuleLoader::ItemsFromTarget).orElseGet(() -> ModuleLoader.ItemsFromModuleId(moduleId));
                if (targets.isEmpty()) {
                    result.ignoredModules.add(moduleId);
                    VariantsCitMod.LOGGER.warn("Skipped VCIT module with no valid item: {}", (Object)moduleId);
                    continue;
                }
                if (prototype.definition.modelPrefix().equals("item/")) {
                    VariantsCitMod.LOGGER.error("VCIT module `{}` has an empty model prefix. This can lead to unexpected behaviours and performance loss.", (Object)moduleId);
                }
                ICitModule moduleLogic = ModuleRegistry.CreateModule(prototype.definition, prototype.parameters);
                VariantLibrary library = result.modelAggregator.CreateLibrary(prototype, manager);
                MetaModule meta = new MetaModule(moduleId, prototype, new BakedModule(library, moduleLogic));
                result.uniqueModules.put(moduleId, meta.bakedModule());
                for (class_6880 item : targets) {
                    result.modulesPerItem.computeIfAbsent((class_6880<class_1792>)item, __ -> new ArrayList()).add(meta);
                }
            }
            catch (IllegalStateException e) {
                VariantsCitMod.LOGGER.error("Error in VCIT module {}: {}", entry.getKey(), (Object)e);
            }
        }
        for (List list : result.modulesPerItem.values()) {
            list.sort((a, b) -> -Integer.compare(a.prototype.definition.priority(), b.prototype.definition.priority()));
        }
        return result;
    }

    private static void Warn(Map<class_2960, class_3298> resources) {
        if (!resources.isEmpty()) {
            Object names = "";
            for (class_2960 id : resources.keySet()) {
                names = (String)names + " ";
                names = (String)names + ModuleLoader.ModuleIdFromResourceId(id).toString();
            }
            VariantsCitMod.LOGGER.warn("Some VCIT modules are using the old mispelled directory `variant-cits`, those should be moved to `variants-cit` instead:{}", names);
        }
    }

    private static Set<class_6880<class_1792>> ItemsFromTarget(List<class_2960> targets) {
        HashSet<class_6880<class_1792>> result = new HashSet<class_6880<class_1792>>();
        targets.stream().map(id -> class_7923.field_41178.method_55841(id).orElse(null)).filter(o -> o != null).forEach(result::add);
        return result;
    }

    private static Set<class_6880<class_1792>> ItemsFromModuleId(class_2960 moduleId) {
        class_2960 itemId = ModuleLoader.ItemIdFromModuleId(moduleId);
        if (class_7923.field_41178.method_10250(itemId)) {
            return Set.of((class_6880)class_7923.field_41178.method_55841(itemId).get());
        }
        return Set.of();
    }

    private static class_2960 ItemIdFromModuleId(class_2960 resource) {
        String path = resource.method_12832();
        path = path.substring("item/".length());
        return class_2960.method_60655((String)resource.method_12836(), (String)path);
    }

    private static class_2960 ModuleIdFromResourceId(class_2960 resource) {
        String path = resource.method_12832();
        path = path.substring("variant-cits/".length(), path.length() - ".json".length());
        return class_2960.method_60655((String)resource.method_12836(), (String)path);
    }

    private static DataResult<ProtoModule> DefinitionFromResource(class_3298 resource) {
        JsonObject json;
        try {
            json = class_3518.method_15255((Reader)resource.method_43039());
        }
        catch (JsonParseException | IOException e) {
            return DataResult.error(((Exception)e)::toString);
        }
        DataResult dataResult = ModuleDefinition.CODEC.decoder().decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (dataResult.isError()) {
            return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)dataResult.error().get())).message());
        }
        try {
            ModuleDefinition definition = (ModuleDefinition)((Pair)dataResult.getOrThrow()).getFirst();
            JsonObject parameters = json.getAsJsonObject("parameters");
            if (parameters == null) {
                parameters = new JsonObject();
            }
            return DataResult.success((Object)new ProtoModule(definition, parameters));
        }
        catch (ClassCastException | IllegalStateException e) {
            return DataResult.error(e::toString);
        }
    }

    public static class Result {
        public final HashMap<class_2960, BakedModule> uniqueModules = new HashMap();
        public final HashSet<class_2960> ignoredModules = new HashSet();
        public final Map<class_6880<class_1792>, List<MetaModule>> modulesPerItem = new HashMap<class_6880<class_1792>, List<MetaModule>>();
        public final ModelAggregator modelAggregator = new ModelAggregator();
    }

    record ProtoModule(ModuleDefinition definition, JsonObject parameters) {
    }

    public record MetaModule(class_2960 id, ProtoModule prototype, BakedModule bakedModule) {
    }
}

