package fr.estecka.variantscit.format;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import com.mojang.serialization.Codec;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VCitRegistries;

public interface INbtInput
extends Function<class_2520,String>
{
	static public final INbtInput AUTO = Grouped(INbtInput::RichText, INbtInput::String, INbtInput::Number, INbtInput::RichTextArray);
	static public final INbtInput PRIMITIVE = Grouped(INbtInput::String, INbtInput::Number);

	static public final Codec<INbtInput> CODEC = VCitRegistries.NBT_INPUTS.codec;
	static public final Codec<INbtInput[]> ARRAY_CODEC = CodecUtil.OneOrMany(CODEC).xmap(list->list.toArray(INbtInput[]::new), array->List.<INbtInput>of(array));
	static public final Codec<INbtInput> GROUP_CODEC = ARRAY_CODEC.xmap(INbtInput::Grouped, type -> type instanceof Group group ? group.content() : new INbtInput[]{ type } );

	public record Group(INbtInput... content)
	implements INbtInput
	{
		public String apply(class_2520 nbt){
			for (int i=0; i<content.length; ++i){
				String result = content[i].apply(nbt);
				if (result != null)
					return result;
			}
			return null;
		}

	}

	static public INbtInput Grouped(INbtInput... group){
		if (group.length == 1)
			return group[0];
		else
			return new Group(group);
	}

	static public String String (class_2520 nbt) { return nbt instanceof class_2519 string ? string.comp_3831() : null; }
	static public String Number (class_2520 nbt) { return nbt instanceof class_2514 number ? number.method_10702().toString() : null; }
	static public String Identifier (class_2520 nbt) {
		class_2960 id;
		if (nbt instanceof class_2519 string && null != (id=class_2960.method_12829(string.comp_3831())))
			return id.toString();
		else
			return null;
	}

	static public String RichText(class_2520 nbt){
		var text = class_8824.field_46597.parse(class_2509.field_11560, nbt);
		if (text.isSuccess())
			return text.getOrThrow().getString();

		return null;
	}

	static public String RichTextArray(class_2520 nbt){
		var result = class_8824.field_46597.sizeLimitedListOf(256).parse(class_2509.field_11560, nbt);
		if (!result.isSuccess())
			return null;

		List<class_2561> lines = result.getOrThrow();
		StringBuilder builder = new StringBuilder();
		for (var l : lines) {
			builder.append(l.getString());
			builder.append('\n');
		}

		return builder.toString();
	}
}
