/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.format.Substitution;
import fr.estecka.variantscit.format.properties.AxolotlVariantProperty;
import fr.estecka.variantscit.format.properties.EntityAgeMapProperty;
import fr.estecka.variantscit.format.properties.IStringProperty;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.modules.IModuleBaker;
import fr.estecka.variantscit.modules.impl.FallbackModule;
import fr.estecka.variantscit.modules.impl.MultiComponentFormatModule;
import fr.estecka.variantscit.modules.libraries.VariantLibrary;
import java.util.HashMap;
import net.minecraft.class_2960;

public final class AxolotlBucketModule {
    public static final IModuleBaker<Params> BAKER = new IModuleBaker<Params>(){

        @Override
        public IBakedModule Bake(VariantLibrary library, Params parameters) {
            return library.Bake(parameters.module);
        }

        @Override
        public boolean AcceptVariant(class_2960 variantId, Params parameters) {
            return variantId.method_12832().endsWith(parameters.adult) || variantId.method_12832().endsWith(parameters.baby);
        }
    };
    public static final MapCodec<Params> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(o -> false), (App)CodecUtil.IDENTIFIER_PATH.optionalFieldOf("adultSuffix", (Object)"").forGetter(o -> ""), (App)CodecUtil.IDENTIFIER_PATH.optionalFieldOf("babySuffix", (Object)"_baby").forGetter(o -> "")).apply((Applicative)builder, (debug, adult, baby) -> new Params(AxolotlBucketModule.Create(debug, adult, baby), (String)adult, (String)baby)));
    private static final Substitution agedFormat = (Substitution)Substitution.Parse("${variant}${age}").getOrThrow();
    private static final HashMap<String, IStringProperty> ageInvariantVariables = new HashMap();

    public static ICitModule Create(boolean debug, String adult, String baby) {
        ICitModule result = AxolotlBucketModule.CreateAgeInvariantModule(debug, adult);
        if (!adult.equals(baby)) {
            result = new FallbackModule(AxolotlBucketModule.CreateAgedModule(debug, adult, baby), result);
        }
        return result;
    }

    public static MultiComponentFormatModule CreateAgedModule(boolean debug, String adult, String baby) {
        HashMap<String, IStringProperty> variables = new HashMap<String, IStringProperty>();
        variables.put("variant", AxolotlVariantProperty.UNIT);
        variables.put("age", new EntityAgeMapProperty(adult, baby));
        return new MultiComponentFormatModule(debug, agedFormat, variables);
    }

    public static MultiComponentFormatModule CreateAgeInvariantModule(boolean debug, String suffix) {
        return new MultiComponentFormatModule(debug, (Substitution)Substitution.Parse("${variant}" + suffix).getOrThrow(), ageInvariantVariables);
    }

    static {
        ageInvariantVariables.put("variant", AxolotlVariantProperty.UNIT);
    }

    private record Params(ICitModule module, String adult, String baby) {
    }
}

