package fr.estecka.variantscit.modules;

import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.modulebakers.LinearLibrary;
import fr.estecka.variantscit.modulebakers.LinearLibrary.ILinearCitModule;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public record ItemCountModule(String namespace)
implements ILinearCitModule
{
	static public final MapCodec<ItemCountModule> CODEC = CodecUtil.IDENTIFIER_NAMESPACE
		.optionalFieldOf("namespace", "minecraft")
		.xmap(ItemCountModule::new, ItemCountModule::GetNamespace)
		;

	@Override
	public String GetNamespace() {
		return namespace;
	}

	@Override
	public class_2960 GetItemModel(class_1799 stack, LinearLibrary library){
		return library.GetOrLesser(stack.method_7947());
	}
}
