package fr.estecka.variantscit.selectors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10448;
import net.minecraft.class_10448.class_10449;
import net.minecraft.class_10526;
import net.minecraft.class_2960;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.duck.DynamicModelResolverDuck;

public class DynamicRangeDispatchUnbaked
implements class_10439.class_10441
{
	static public final MapCodec<DynamicRangeDispatchUnbaked> CODEC = RecordCodecBuilder.mapCodec( instance ->
		instance.group(
			class_10448.class_10450.field_55361.forGetter(u->u.inner),
			class_2960.field_25139.optionalFieldOf("variants-cit:baseId").forGetter(u->u.modelPrefix)
		)
		.apply(instance, DynamicRangeDispatchUnbaked::new)
	);

	private final Optional<class_2960> modelPrefix;
	private class_10448.class_10450 inner;

	public DynamicRangeDispatchUnbaked(class_10448.class_10450 inner, Optional<class_2960> modelPrefix){
		this.modelPrefix = modelPrefix;
		this.inner = inner;
	}

	@Override
	public MapCodec<DynamicRangeDispatchUnbaked> method_65585(){
		return CODEC;
	}

	@Override
	public void method_62326(class_10526.class_10103 resolver){
		if (modelPrefix.isEmpty())
			; // no-op
		else if (resolver instanceof DynamicModelResolverDuck dyn){
			Map<class_2960,Float> models = dyn.<Float>variantscit$ResolveIf(this::GetThreshold);
			List<class_10448.class_10449> entries = new ArrayList<>(inner.comp_3397());
			for (var entry : models.entrySet()){
				entries.add(new class_10449(entry.getValue(), new class_10430.class_10431(entry.getKey(), List.of())));
			}
			inner = new class_10448.class_10450(inner.comp_3395(), inner.comp_3396(), entries, inner.comp_3398());
		} else
			VariantsCitMod.LOGGER.error("Unable to dynamically resolve dispatch_range: {}", resolver.getClass());

		inner.method_62326(resolver);
	}

	@Override
	public class_10439 method_65587(class_10439.class_10440 context){
		return inner.method_65587(context);
	}

	private Optional<Float> GetThreshold(class_2960 id){
		if (!modelPrefix.get().method_12836().equals(id.method_12836()))
			return Optional.empty();

		final String prefix = this.modelPrefix.get().method_12832();
		String path = id.method_12832();
		if (!path.startsWith(prefix))
			return Optional.empty();

		try {
			return Optional.of(Float.parseFloat(path.substring(prefix.length())));
		}
		catch (NumberFormatException e){
			return Optional.empty();
		}
	}

}
