package fr.estecka.variantscit.modules;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.format.IStringTransform;
import fr.estecka.variantscit.format.NbtAdapter;
import fr.estecka.variantscit.format.properties.IStringProperty;
import fr.estecka.variantscit.format.properties.ItemComponentProperty;
import fr.estecka.variantscit.format.properties.TransformableProperty;
import fr.estecka.variantscit.format.transforms.SuccessiveTransform;

public class ComponentDataModule<P extends IStringProperty>
extends ASimpleMultiComponentCachingModule
{
	static public final MapCodec<ComponentDataModule<IStringProperty>> CODEC = RecordCodecBuilder.mapCodec(builder->builder
		.group(
			IStringProperty.MAP_CODEC.forGetter(o->o.property),
			Codec.BOOL.fieldOf("debug").orElse(false).forGetter(o->o.debug)
		)
		.apply(builder, ComponentDataModule::new)
	);

	@Deprecated
	static public final <T> MapCodec<ComponentDataModule<TransformableProperty<ItemComponentProperty>>> CreateLegacyCodec(class_9331<T> componentType){
		return RecordCodecBuilder.mapCodec(builder->builder
			.group(
				LegacyPropertyCodec(componentType).forGetter(o->o.property),
				Codec.BOOL.fieldOf("debug").orElse(false).forGetter(o -> o.debug)
			)
			.apply(builder, (property, debug) -> {
				VariantsCitMod.LOGGER.warn("Module types `custom_data`, `entity_data`, `bucket_entity_data` and `block_entity_data` are being deprecated. Use `component_data` instead.");
				return new ComponentDataModule<>(property, debug);
			})
		);
	}

	@Deprecated
	static public final <T> MapCodec<TransformableProperty<ItemComponentProperty>> LegacyPropertyCodec(class_9331<T> componentType){
		return RecordCodecBuilder.mapCodec(builder->builder
			.group(
				CodecUtil.MapWithAlternative(NbtAdapter.MAPCODEC, NbtAdapter.LEGACY_MAPCODEC).forGetter(o->o.inner().nbtAdapter()),
				CodecUtil.MapWithAlternative(SuccessiveTransform.CODEC.fieldOf("transform"), IStringTransform.LEGACY_CODEC.fieldOf("lowercase")).orElse(IStringTransform.NOOP).forGetter(o->o.transform())
			)
			.apply(builder, (adapter, transform) -> new TransformableProperty<>(new ItemComponentProperty(componentType, adapter), transform, Optional.empty()))
		);
	}

	private final P property;

	public ComponentDataModule(P property, boolean debug){
		super(debug, Stream.of(property));
		this.property = property;
	}

	@Override
	public @Nullable class_2960 RecomputeItemVariant(class_1799 stack) {
		String result = this.property.GetPropertyString(stack);
		return (result!=null) ? class_2960.method_12829(result) : null;
	}
}
