package fr.estecka.variantscit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import fr.estecka.variantscit.ModuleLoader.ProtoModule;

public class ModelAggregator
{
	public final Set<class_1091> modelsToLoad = new HashSet<>();
	public final Map<class_1091, class_2960> modelsToCreate = new HashMap<>();

	public VariantLibrary CreateLibrary(ProtoModule prototype, class_3300 manager){
		Map<class_2960,class_1091> allVariants = new HashMap<>();
		Map<String,class_1091> allSpecials = new HashMap<>();

		final String prefix = prototype.definition().modelPrefix();
		final Optional<class_2960> modelParent = prototype.definition().modelParent();
		final var specials = new HashMap<>(prototype.definition().specialModels());
		prototype.definition().fallbackModel().ifPresent(fallback -> specials.put(null, fallback));

		var varModels = FindVariants(manager, "models", prefix, ".json");
		var speModels = FindSpecials(manager, "models", specials, ".json");
		allVariants.putAll(varModels);
		allSpecials.putAll(speModels);
		this.modelsToLoad.addAll(varModels.values());
		this.modelsToLoad.addAll(speModels.values());

		if (modelParent.isPresent())
		{
			var varTextures = FindVariants(manager, "textures", prefix, ".png" );
			var speTextures = FindSpecials(manager, "textures", specials, ".png" );
			varModels.keySet().forEach(varTextures::remove);
			speModels.keySet().forEach(speTextures::remove);
			allVariants.putAll(varTextures);
			allSpecials.putAll(speTextures);
			varTextures.values().forEach(model -> AddModelToCreate(model, modelParent.get()));
			speTextures.values().forEach(model -> AddModelToCreate(model, modelParent.get()));
		}

		allSpecials.remove(null);
		return new VariantLibrary(
			prototype.definition().GetFallbackModelId(),
			allVariants,
			allSpecials
		);
	}

	private void AddModelToCreate(class_1091 model, class_2960 parent){
		if  (!this.modelsToCreate.containsKey(model))
			modelsToCreate.put(model, parent);
		else if (!modelsToCreate.get(model).equals(parent))
			VariantsCitMod.LOGGER.error("Conflicting definitions for model {}", model.comp_2875());
	}

	/**
	 * Finds all models/textures for a given prefix.
	 * @return Maps the variant ID to its corresponding model ID
	 */
	private Map<class_2960,class_1091> FindVariants(class_3300 manager, String rootDirectory, String modelPrefix, String suffix){
		Map<class_2960, class_1091> results = new HashMap<>();

		String fullPrefix = rootDirectory+'/'+modelPrefix;
		String directory = fullPrefix.substring(0, fullPrefix.lastIndexOf('/'));
		for (class_2960 fileId : manager.method_14488(directory, id -> id.method_12832().startsWith(fullPrefix) && id.method_12832().endsWith(suffix)).keySet())
		{
			String namespace = fileId.method_12836();
			String modelName, variantName;
			modelName = fileId.method_12832();
			modelName = modelName.substring((rootDirectory+'/').length(), modelName.length()-suffix.length());
			variantName = modelName.substring(modelPrefix.length());

			results.put(
				class_2960.method_60655(namespace, variantName),
				VariantsCitMod.ModelIdFromResource(class_2960.method_60655(namespace, modelName))
			);
		}

		return results;
	}

	/**
	 * Finds which of the requested model/texture IDs are actually available.
	 * @return The model/texture IDs
	 */
	private Map<String,class_1091> FindSpecials(class_3300 manager, String rootDirectory, Map<String,class_2960> requested, String suffix){
		Set<class_2960> valid = new HashSet<>();

		// ResourceId to ModelId
		Map<class_2960, class_2960> resourceIds = requested.values().stream().collect(Collectors.toMap(
			id -> id.method_45138(rootDirectory+'/').method_48331(suffix),
			id -> id
		));
		for (class_2960 fileId : manager.method_14488(rootDirectory, id->resourceIds.keySet().contains(id)).keySet())
			valid.add(resourceIds.get(fileId));

		return requested.entrySet().stream()
			.filter(e -> valid.contains(e.getValue()))
			.collect(Collectors.toMap(
				Map.Entry::getKey,
				e-> VariantsCitMod.ModelIdFromResource(e.getValue())
			))
			;
	}

}
