package fr.estecka.variantscit;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.api.ModuleRegistrar.ComplexCitModuleFactory;
import fr.estecka.variantscit.api.ModuleRegistrar.ParameterizedCitModuleFactory;
import fr.estecka.variantscit.api.ModuleRegistrar.SpecialCitModuleFactory;

public final class ModuleRegistry
{
	@FunctionalInterface
	static private interface ModuleFactory {
		ICitModule build(ModuleDefinition definition, JsonObject customData) throws IllegalStateException;
	}

	static private final Map<class_2960, ModuleFactory> MODULE_TYPES = new HashMap<>();

	@Deprecated
	static public <T> void Register(class_2960 type, ComplexCitModuleFactory<T> moduleFactory, MapCodec<T> codec){
		assert moduleFactory != null;
		RegisterManager(type, (config, json) -> {
			var data = codec.decoder().decode(JsonOps.INSTANCE, json);
			return moduleFactory.Build(config.GetSpecialModelIds(), data.getOrThrow().getFirst());
		});
	}

	@Deprecated
	static public <T> void Register(class_2960 type, ParameterizedCitModuleFactory<T> moduleFactory, MapCodec<T> codec){
		assert moduleFactory != null;
		RegisterManager(type, (config, json) -> {
			var data = codec.decoder().decode(JsonOps.INSTANCE, json);
			return moduleFactory.Build(data.getOrThrow().getFirst());
		});
	}

	static public void Register(class_2960 type, MapCodec<? extends ICitModule> codec){
		assert codec != null;
		RegisterManager(type, (config, json) -> {
			return codec.decoder().decode(JsonOps.INSTANCE, json).getOrThrow().getFirst();
		});
	}

	@Deprecated
	static public void Register(class_2960 type, SpecialCitModuleFactory moduleFactory){
		assert moduleFactory != null;
		RegisterManager(type, (config,json)->moduleFactory.Build(config.GetSpecialModelIds()));
	}

	static public void Register(class_2960 type, ICitModule module){
		assert module != null;
		RegisterManager(type, (config,json)-> module);
	}

	static private void RegisterManager(class_2960 type, ModuleFactory factory){
		assert type != null;
		assert factory != null;
		if (MODULE_TYPES.containsKey(type))
			throw new RuntimeException("Duplicate cit module registration for " + type.toString());

		MODULE_TYPES.put(type, factory);
	}

	static public ICitModule CreateModule(ModuleDefinition definition, JsonObject customData)
	throws IllegalStateException
	{
		assert definition != null;
		class_2960 type = definition.type();

		if (!MODULE_TYPES.containsKey(type))
			throw new IllegalStateException("Unknown module type: " + type.toString());

		return MODULE_TYPES.get(type).build(definition, customData);
	}
}
