package fr.estecka.variantscit.mixin;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import net.minecraft.class_9824;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import fr.estecka.variantscit.VariantsCitMod;

@Mixin(class_1092.class)
public class ModelLoaderMixin
{
	/**
	 * I could probably use the constructor for JsonUnbakedModel instead, but it
	 * is unclear how parent-child inheritance works with it.
	 */
	static private final String ARBITRARY_MODEL = """
		{
			"parent": "%s",
			"textures": {
				"layer0": "%s"
			}
		}
	""";

	@Unique
	private class_1100 CreateFromTexture(class_2960 resourceId, class_2960 parent) {
		StringReader reader = new StringReader(ARBITRARY_MODEL.formatted(parent.toString(), resourceId.toString()));
		class_793 model = class_793.method_3437(reader);
		return model;
	}


	@Inject( method="collect", at=@At("HEAD"))
	private void AddVariantModels(class_1100 missingModel, Map<class_2960, class_1100> inputs, class_9824.class_10095 definition, CallbackInfoReturnable<?> ci, @Local(argsOnly=true) LocalRef<Map<class_2960, class_1100>> inputRef)
	{
		// Make mutable
		inputs = new HashMap<>(inputs);
		inputRef.set(inputs);

		var models = VariantsCitMod.GetModelsToCreate();
		VariantsCitMod.LOGGER.info("Creating {} item models from textures...", models.size());
		for (var entry : VariantsCitMod.GetModelsToCreate().entrySet()){
			class_2960 resourceId = entry.getKey().comp_2875().method_45138("item/");
			inputs.put(resourceId, this.CreateFromTexture(resourceId, entry.getValue()));
		}
	}
}
