/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.transforms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.format.IStringTransform;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public record RegexTransform(Pattern pattern, String substitution, boolean matchAll, @Deprecated boolean validate) implements IStringTransform
{
    public static final MapCodec<RegexTransform> MAPCODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.comapFlatMap(RegexTransform::ParsePattern, Pattern::toString).fieldOf("regex").forGetter(RegexTransform::pattern), (App)Codec.STRING.optionalFieldOf("substitution", (Object)"$0").forGetter(RegexTransform::substitution), (App)Codec.BOOL.optionalFieldOf("matchAll", (Object)true).forGetter(RegexTransform::matchAll), (App)Codec.BOOL.optionalFieldOf("validate", (Object)true).forGetter(RegexTransform::validate)).apply((Applicative)instance, RegexTransform::new));

    public static DataResult<Pattern> ParsePattern(String regex) {
        try {
            return DataResult.success((Object)Pattern.compile(regex));
        }
        catch (PatternSyntaxException e) {
            return DataResult.error(e::toString);
        }
    }

    @Override
    public String apply(String input) {
        Matcher match = this.pattern.matcher(input);
        if (this.matchAll ? match.matches() : match.find()) {
            try {
                return match.replaceAll(this.substitution);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                VariantsCitMod.LOGGER.error("Error in regex substitution: {}\n{}]", (Object)this.substitution, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.validate ? null : input;
    }
}

