package fr.estecka.variantscit;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Map.Entry;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;

public class CodecUtil
{
	static private final class_310 client = class_310.method_1551();

	static public final Codec<String> IDENTIFIER_PATH = Codec.STRING.validate(path->class_2960.method_20208(path) ? DataResult.success(path) : DataResult.error(()->"Invalid character in path: "+path));
	static public final Codec<String> IDENTIFIER_NAMESPACE = Codec.STRING.validate(path->class_2960.method_20209(path) ? DataResult.success(path) : DataResult.error(()->"Invalid character in namespace: "+path));
	static public final Codec<String> NONEMPTY_STRING = Codec.STRING.validate(string->string.isEmpty() ? DataResult.error(()->"String cannot be empty") : DataResult.success(string));
	static public final Codec<Character> CHAR = Codec.string(1,1).xmap(s->s.charAt(0), c->String.valueOf(c));

	/**
	 * Functions to be used in `validate()` on deprecated codecs.
	 */
	static public <T> Function<T,DataResult<T>> WithWarning(String warning, Object... args){
		return o->{
			VariantsCitMod.LOGGER.warn(warning, args);
			return DataResult.success(o);
		};
	}

	static public <T> MapCodec<T> WithWarning(MapCodec<T> codec, String warning, Object... args){
		return codec.validate(WithWarning(warning, args));
	}

	static public <T> Codec<List<T>> OneOrMany(Codec<T> original){
		var listCodec = original.listOf();
		return Codec.withAlternative(
			listCodec,
			Codec.of(listCodec, original.map(List::of))
		);
	}

	static public <T> MapCodec<T> MapWithAlternative(MapCodec<T> primary, MapCodec<? extends T> alternative){
		return MapCodec.assumeMapUnsafe(
			Codec.withAlternative(
				primary.codec(),
				alternative.codec()
			)
		);
	}

	@SafeVarargs
	static public <T> Codec<T> WithAlternatives(Codec<T> primary, Codec<T>... altArray){
		int i = altArray.length - 1;
		Codec<T> alternative = altArray[i];

		for (i=i-1; i>=0; --i){
			alternative = Codec.withAlternative(altArray[i], alternative);
		}

		return Codec.withAlternative(primary, alternative);
	}

	@SafeVarargs
	static public <T> MapCodec<T> MapWithAlternatives(MapCodec<T> primaryMap, MapCodec<T>... mapArray){
		@SuppressWarnings("unchecked")
		Codec<T>[] codecArray = new Codec[mapArray.length];
		for (int i=0; i<mapArray.length; ++i)
			codecArray[i] = mapArray[i].codec();
		return MapCodec.assumeMapUnsafe(WithAlternatives(primaryMap.codec(), codecArray));
	}

	static public <T> MapCodec<T> WithAlias(Codec<T> codec, String primary, String alias){
		return MapWithAlternative(
			codec.fieldOf(primary),
			codec.fieldOf(alias).validate(WithWarning("VCIT field `{}` is deprecated. Use `{}` instead.", alias, primary))
		);
	}

	static public <K,V> Codec<V> Enum(Codec<K> keyCodec, Map<K,V> units){
		return keyCodec.<V>flatXmap(
			key -> units.containsKey(key) ?
				DataResult.success(units.get(key)) :
				DataResult.error(()->"Unknown key: " + key.toString()),
			obj -> units.containsValue(obj) ?
				DataResult.success(units.entrySet().stream().filter(entry->obj.equals(entry.getValue())).map(Entry::getKey).findFirst().get()) :
				DataResult.error(()->"Unknown unit")
		);
	}

	static public <T> MapCodec<Optional<T>> OptionalWithAlias(Codec<T> codec, String primary, String alias){
		return WithAlias(codec, primary, alias)
			.xmap(Optional::of, Optional::get)
			.orElse(Optional.empty())
			;
	}

	static public <T> @Nullable class_2520 GetComponentNbt(class_1799 stack, class_9331<T> type){
		T component = stack.method_57824(type);
		if (component == null)
			return null;
		else
			return GetComponentNbt(component, type.method_57876());
	}

	static public <T> @Nullable class_2520 GetComponentNbt(T component, Codec<T> codec){
		DynamicOps<class_2520> nbtOps = class_2509.field_11560;
		// Enables encoding of data from dynamic registries
		if (client.field_1687 != null)
			nbtOps = client.field_1687.method_30349().method_57093(nbtOps);

		var dataResult = codec.encodeStart(nbtOps, component);
		if (dataResult.isSuccess())
			return dataResult.getOrThrow();
		else {
			VariantsCitMod.LOGGER.error("Unable to serialize component: {}", dataResult.error().get().message() );
			return null;
		}
	}

	/**
	 * Downcast the decoder's result to a superclass. This strips the codec of
	 * its encoding abilities.
	 */
	static public <SUPER, SUB extends SUPER> MapCodec<SUPER> Anonymize(MapCodec<SUB> original){
		return original.flatXmap(
			o->DataResult.success((SUPER)o),
			o->DataResult.error(()->"Encoding not supported by anonymized codec.")
		);
	}
}
