package fr.estecka.variantscit;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9331;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class MultiPropertyCache
{
	static public interface ICachableItemProperty
	{
		int GetPropertyHash(class_1799 stack);
		Object GetReference(class_1799 stack);
	}

	public final boolean debug;
	private final ICachableItemProperty[] properties;
	private final Int2ObjectMap<CacheEntry> hashToVariant = new Int2ObjectOpenHashMap<>();
	private final ReferenceQueue<Object> expiredComponents = new ReferenceQueue<>();

	public MultiPropertyCache(boolean debug, Stream<? extends ICachableItemProperty> properties){
		this.debug = debug;
		this.properties = properties.distinct().toArray(ICachableItemProperty[]::new);
	}

	public MultiPropertyCache(boolean debug, class_9331<?> component){
		this(debug, Stream.of(ComponentProperty(component)));
	}

	static private ICachableItemProperty ComponentProperty(class_9331<?> type){
		return new ICachableItemProperty() {
			@Override
			public int GetPropertyHash(class_1799 stack) {
				return stack.method_57824(type).hashCode();
			}
			@Override
			public Object GetReference(class_1799 stack) {
				return stack.method_57824(type);
			}
		};
	}

	public class_2960 ComputeIfAbsent(class_1799 stack, Function<class_1799,class_2960> computer){
		this.ExpungeExpiredEntries();

		int hash = this.HashStack(stack);
		CacheEntry entry = this.hashToVariant.get(hash);
		if (entry == null) {
			class_2960 variant = computer.apply(stack);
			entry = this.CreateEntry(hash, stack, variant);
			if (debug)
				VariantsCitMod.LOGGER.info("Cache size: {}; Latest Model Id: {}", hashToVariant.size(), String.valueOf(entry.variant));
		}
		return entry.variant;
	}

	/**
	 * @see {@linkplain java.util.Arrays#hashCode(Object[])}
	 */
	private int HashStack(class_1799 stack){
		int hash = 17;
		for (var prop : this.properties){
			hash = hash*31 + prop.GetPropertyHash(stack);
		}
		return hash;
	}

	/**
	 * TODO: As-is, an entry where all registered components are null will never
	 * expire. This is limited to one entry per cache, so it is negligible.
	 */
	private CacheEntry CreateEntry(int hash, class_1799 stack, class_2960 variant){
		WeakReference<?>[] weakRefs = new WeakReference[properties.length];

		for (int i=0; i<properties.length; ++i){
			Object ref = properties[i].GetReference(stack);
			if (ref != null)
				weakRefs[i] = new HashedWeakReference(hash, ref, this.expiredComponents);
		}

		CacheEntry entry = new CacheEntry(variant, weakRefs);
		this.hashToVariant.put(hash, entry);
		return entry;
	}

	private void ExpungeExpiredEntries(){
		HashedWeakReference weakRef;
		while ((weakRef=(HashedWeakReference)expiredComponents.poll()) != null){
			this.hashToVariant.remove(weakRef.hash);
		}
	}

	static private class HashedWeakReference
	extends WeakReference<Object>
	{
		/**
		 * The key of the associated entry that must be cleared along with this
		 * reference.
		 */
		public final int hash;

		public HashedWeakReference(int hash, Object referent, ReferenceQueue<Object> queue){
			super(referent, queue);
			this.hash = hash;
		}
	}

	/**
	 * Weak references are kept around so that the weak reference itself doesn't
	 * get garbage collected  before its referee. Otherwise, references will not
	 * get enqueued, and the cache will never be cleared.
	 */
	static private record CacheEntry(class_2960 variant, WeakReference<?>[] components)
	{}
}
