package fr.estecka.variantscit.format.properties;

import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public abstract class AMonoComponentProperty<T>
implements IStringProperty
{
	protected final class_9331<T> componentType;

	protected AMonoComponentProperty(class_9331<T> componentType){
		this.componentType = componentType;
	}

	public abstract String GetPropertyString(T component);

	@Override
	public final @Nullable T GetReference(class_1799 stack) {
		return stack.method_57824(componentType);
	}

	@Override
	public final int GetPropertyHash(class_1799 stack) {
		return Objects.hashCode(GetReference(stack));
	}

	@Override
	public final String GetPropertyString(class_1799 stack) {
		T component = GetReference(stack);
		return (component!=null) ? GetPropertyString(component) : null;
	}
}
