package fr.estecka.variantscit.reload;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VCitRegistries;

public record ModuleDefinition(
	@Deprecated class_2960 type,
	UnbakedModule<?> parameters,
	List<EModuleContext> contexts,
	Optional<List<class_2960>> targets,
	int priority,
	String modelPrefix,
	boolean itemGen,
	Optional<class_2960> modelParent,
	Optional<class_2960> fallbackModel,
	Map<String,class_2960> specialModels
)
{
	static public final MapCodec<ModuleDefinition> CODEC = RecordCodecBuilder.<ModuleDefinition>mapCodec(builder->builder
		.group(
			class_2960.field_25139.fieldOf("type").forGetter(ModuleDefinition::type),
			VCitRegistries.MODULES.mapCodec.forGetter(ModuleDefinition::parameters),
			CodecUtil.OneOrMany(EModuleContext.CODEC).optionalFieldOf("context", List.of(EModuleContext.ITEM_MODEL)).forGetter(ModuleDefinition::contexts),
			CodecUtil.OneOrMany(class_2960.field_25139).optionalFieldOf("items").forGetter(ModuleDefinition::targets),
			Codec.INT.fieldOf("priority").orElse(0).forGetter(ModuleDefinition::priority),
			Codec.STRING.validate(ModuleDefinition::ValidatePath).fieldOf("modelPrefix").forGetter(ModuleDefinition::modelPrefix),
			Codec.BOOL.fieldOf("itemsFromModels").orElse(true).forGetter(ModuleDefinition::itemGen),
			class_2960.field_25139.optionalFieldOf("modelParent").forGetter(ModuleDefinition::fallbackModel),
			class_2960.field_25139.validate(ModuleDefinition::UnItemify).optionalFieldOf("fallback").forGetter(ModuleDefinition::fallbackModel),
			Codec.unboundedMap(Codec.STRING, class_2960.field_25139.validate(ModuleDefinition::UnItemify)).optionalFieldOf("special", ImmutableMap.<String,class_2960>of()).forGetter(ModuleDefinition::specialModels)
		)
		.apply(builder, ModuleDefinition::new)
	);

	static private String UnItemify(String modelPrefix){
		if (modelPrefix.startsWith("item/")){
			// VariantsCitMod.LOGGER.warn("Stripped leading \"item/\" from model path: \"{}\"", modelPrefix);
			modelPrefix = modelPrefix.substring("item/".length());
		}
		return modelPrefix;
	}

	static private DataResult<class_2960> UnItemify(class_2960 original){
		return DataResult.success(class_2960.method_60655(original.method_12836(), UnItemify(original.method_12832())));
	}

	static public DataResult<String> ValidatePath(String path){
		if (class_2960.method_20208(path))
			return DataResult.success(UnItemify(path));
		else
			return DataResult.error(()->"Invalid character in path: "+path);
	}
}
