package fr.estecka.variantscit.reload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.VariantsCitMod;

public final class ModuleLoader
{
	static public class Result {
		public final Map<class_1792, IBakedModule> itemModules  = new HashMap<>();
		public final Map<class_1792, IBakedModule> equipModules = new HashMap<>();
		public final Map<class_2960, MetaModule> allModules = new HashMap<>();
		public final VariantAggregator variantAggregator;

		private Result(Map<class_2960,ModuleDefinition> modules){
			this.variantAggregator = new VariantAggregator(modules);
		}
	}

	static public ModuleLoader.Result ReloadModules(class_3300 manager)
	{
		final ModuleLoader.Result result;
		final List<MetaModule> metamodules = new ArrayList<>();

		Map<class_2960, class_3298> resources = new HashMap<>();
		Map<class_2960, ModuleDefinition> definitions = new HashMap<>();
		resources.putAll(manager.method_14488("variant-cits/item", id->id.method_12832().endsWith(".json")));
		ObsoletePathWarning(resources);
		resources.putAll(manager.method_14488("variants-cit/item", id->id.method_12832().endsWith(".json")));
		for (var entry : resources.entrySet())
		{
			class_2960 moduleId = ModuleIdFromResourceId(entry.getKey());
			var optDefinition = DefinitionFromResource(entry.getValue());
			if (optDefinition.isError()){
				VariantsCitMod.LOGGER.error("Error in VCIT module {}: {}", moduleId, optDefinition.error().get().message());
				continue;
			}

			ModuleDefinition definition = optDefinition.getOrThrow();
			if (definition.contexts().isEmpty()){
				VariantsCitMod.LOGGER.warn("Skipped VCIT module with no context: {}", moduleId);
				continue;
			}
			if (ItemsFromModule(moduleId, definition).isEmpty()){
				VariantsCitMod.LOGGER.warn("Skipped VCIT module with no valid item: {}", moduleId);
				continue;
			}
			if (definition.modelPrefix().isEmpty())
				VariantsCitMod.LOGGER.error("VCIT module `{}` has an empty model prefix. This can lead to unexpected behaviours and performance loss.", moduleId);

			definitions.put(moduleId, definition);
		}

		result = new Result(definitions);
		result.variantAggregator.GatherAll(manager);

		for (var entry : definitions.entrySet())
		{
			class_2960 moduleId = entry.getKey();
			ModuleDefinition definition = entry.getValue();
			Set<class_1792> targets = ItemsFromModule(moduleId, definition);
			MetaModule meta = new MetaModule(
				moduleId,
				definition.priority(),
				targets,
				definition.modelPrefix(),
				result.variantAggregator.GetLibrary(EModuleContext.ITEM_MODEL, definition).map(definition.parameters()::Bake),
				result.variantAggregator.GetLibrary(EModuleContext.EQUIPPABLE, definition).map(definition.parameters()::Bake)
			);

			result.allModules.put(moduleId, meta);
			metamodules.add(meta);
		}

		// Sort highest priorities first.
		metamodules.sort((a,b) -> -Integer.compare(a.priority(), b.priority()));

		if (!result.variantAggregator.conflictingModelPrefixes.isEmpty()){
			String message = "Some modules with identical model prefixes have conflicting model parents, "
			               + "it is undefined which parent will be used. "
			               + "The following prefixes are involved: "
			               ;
			for (var prefix : result.variantAggregator.conflictingModelPrefixes)
				message += "\n - " + prefix;
			VariantsCitMod.LOGGER.error(message);
		}

		BakeModules(result, metamodules);
		return result;
	}

	static private void ObsoletePathWarning(Map<class_2960, class_3298> resources){
		if (!resources.isEmpty()){
			String names = "";
			for (class_2960 id : resources.keySet()) {
				names += ' ';
				names += ModuleIdFromResourceId(id).toString();
			}
			VariantsCitMod.LOGGER.warn("Some VCIT modules are using the old mispelled directory `variant-cits`, those should be moved to `variants-cit` instead:{}", names);
		}
	}

	static private DataResult<ModuleDefinition> DefinitionFromResource(class_3298 resource){
		JsonObject json;
		try {
			json = class_3518.method_15255(resource.method_43039());
		}
		catch (IOException|JsonParseException e){
			return DataResult.error(e::toString);
		}

		return ModuleDefinition.CODEC.decoder().decode(JsonOps.INSTANCE, json).map(Pair::getFirst);
	}


/******************************************************************************/
/* # Target Item Baking                                                       */
/******************************************************************************/

	static private Set<class_1792> ItemsFromModule(class_2960 moduleId, ModuleDefinition module){
		return module.targets()
			.map(ModuleLoader::ItemsFromTarget)
			.orElseGet(()->ItemsFromModuleId(moduleId))
			;
	}

	static private Set<class_1792> ItemsFromTarget(List<class_2960> targets){
		Set<class_1792> result = new HashSet<>();
		targets.stream()
			.map(id->class_7923.field_41178.method_10223(id))
			.filter(Optional::isPresent)
			.map(opt->opt.get().comp_349())
			.forEach(result::add)
			;
		return result;
	}

	static private Set<class_1792> ItemsFromModuleId(class_2960 moduleId){
		if (class_7923.field_41178.method_10250(moduleId))
			return Set.of(class_7923.field_41178.method_10223(moduleId).get().comp_349());
		else
			return Set.of();
	}

	/**
	 * @implNote TODO: Coincidentally, this handles  both the `variants-cit` and
	 * the `variant-cits` directories. Refactor  will be  required  when modules
	 * are moved to `variants-cit/module/`.
	 */
	static private class_2960 ModuleIdFromResourceId(class_2960 resource){
		String path = resource.method_12832();
		path = path.substring("variants-cit/item/".length(), path.length()-".json".length());
		return class_2960.method_60655(resource.method_12836(), path);
	}

/******************************************************************************/
/* # Module Baking                                                            */
/******************************************************************************/

	static public void BakeModules(ModuleLoader.Result result, List<MetaModule> modules){
		Map<class_1792, List<IBakedModule>> itemModules  = new HashMap<>();
		Map<class_1792, List<IBakedModule>> equipModules = new HashMap<>();
	
		for (MetaModule meta : modules)
		{
			if (meta.itemModule ().isPresent()) BakeModuleContext(meta, meta.itemModule ().get(), itemModules );
			if (meta.equipModule().isPresent()) BakeModuleContext(meta, meta.equipModule().get(), equipModules);
		}

		BakeItem(result.itemModules,  itemModules );
		BakeItem(result.equipModules, equipModules);
	}

	static private void BakeModuleContext(MetaModule meta, IBakedModule bakedModule, Map<class_1792, List<IBakedModule>> output){
		for (class_1792 itemType : meta.targets()){
			output.computeIfAbsent(itemType, __->new ArrayList<>()).add(bakedModule);
		}
	}

	static private void BakeItem(Map<class_1792, IBakedModule> result, Map<class_1792, List<IBakedModule>> moduleListPerItem){
		for (var entry : moduleListPerItem.entrySet()){
			result.put(
				entry.getKey(),
				IBakedModule.OfList( entry.getValue() )
			);
		}
	}


}
