package fr.estecka.variantscit.modules.impl;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.commands.CommandLogger;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap.Entry;

public class EnchantmentModule
extends AComponentCachingModule<class_9304>
{
	static public final MapCodec<EnchantmentModule> CreateCodec(class_9331<class_9304> targetComponent){
		return RecordCodecBuilder.mapCodec(builder->builder
			.group(
				// TODO: Figure out how to restrict it to specific classes
				// Registries.DATA_COMPONENT_TYPE.getCodec().fieldOf("componentType").forGetter(ItemComponentProperty::componentType),
				Codec.unboundedMap(class_2960.field_25139, Codec.INT).optionalFieldOf("requiredEnchantments", Map.of()).forGetter(o->o.precondition),
				Codec.STRING.optionalFieldOf("levelSeparator").forGetter(o->o.separator)
			)
			.apply(builder, (pre,sep)->new EnchantmentModule(targetComponent, pre, sep))
		);
	}

	private final Map<class_2960, Integer> precondition;
	private final Optional<String> separator;

	public EnchantmentModule(
		class_9331<class_9304> component,
		Map<class_2960, Integer> precondition,
		Optional<String> separator
	) {
		super(component);
		this.separator = separator;
		this.precondition = precondition;
	}

	@Override
	public class_2960 GetModelForComponent(class_9304 enchants, IVariantManager library)
	{
		if (enchants == null || enchants.method_57543() || !this.MatchesPrecondition(enchants))
			return null;

		if (enchants.method_57541() > precondition.size()+1 && null != library.GetSpecialModel("multi"))
			return library.GetSpecialModel("multi");

		Entry<class_6880<class_1887>> bestFit = GetBestEnchant(enchants, library);
		if (bestFit == null)
			return null;
		else
			return this.GetEnchantModel(bestFit, library);
	}

	private boolean MatchesPrecondition(class_9304 component){
		// Cast the component, so that the keys are plain identifiers, instead
		// of registry entries.
		Object2IntOpenHashMap<class_2960> enchants = new Object2IntOpenHashMap<>();
		for (var entry : component.method_57539())
			enchants.put(entry.getKey().method_40230().get().method_29177(), entry.getIntValue());

		for (var condition : this.precondition.entrySet()) {
			if (enchants.getInt(condition.getKey()) < condition.getValue())
				return false;
		}

		return true;
	}

	private @Nullable Entry<class_6880<class_1887>> GetBestEnchant(class_9304 enchants, IVariantManager library){
		Entry<class_6880<class_1887>> bestFit = null;
		for (var enchant : enchants.method_57539()){
			if (!this.precondition.containsKey(enchant.getKey().method_40230().get().method_29177())
			&&  CompareEnchants(enchant, bestFit, library) > 0
			){
				bestFit = enchant;
			}
		}

		return bestFit;
	}

	private int CompareEnchants(Entry<class_6880<class_1887>> a, Entry<class_6880<class_1887>> b, IVariantManager library){
		int result = 0;

		if (a == null) return -1;
		if (b == null) return 1;

		result = Boolean.compare(
			this.HasVariantModel(a, library),
			this.HasVariantModel(b, library)
		);
		if (result != 0) return result;

		result = a.getKey().comp_349().comp_2688().method_40247() - b.getKey().comp_349().comp_2688().method_40247();
		if (result != 0) return result;

		result = a.getIntValue() - b.getIntValue();
		if (result != 0) return result;

		return result;
	}

	private class_2960 GetEnchantModel(Entry<class_6880<class_1887>> enchant, IVariantManager library){
		class_2960 variantId = enchant.getKey().method_40230().get().method_29177();

		if (separator.isPresent()) {
			int level = enchant.getIntValue();
			class_2960 baseId = variantId.method_48331(separator.get());

			for (int i=level; 0<=i; --i)
			{
				class_2960 leveledId = baseId.method_48331(String.valueOf(i));
				if (library.HasVariantModel(leveledId)){
					variantId = leveledId;
					break;
				}
			}
		}

		return library.GetVariantModel(variantId);
	}

	private boolean HasVariantModel(Entry<class_6880<class_1887>> enchant, IVariantManager library){
		return null != GetEnchantModel(enchant, library);
	}

	@Override
	public @Nullable class_2960 Walkthrough(class_1799 stack, IVariantManager library, CommandLogger logger) {
		class_9304 enchants = stack.method_58694(this.componentType);
		if (enchants == null || enchants.method_57543()){
			logger.Info("The item does not have any enchantment.");
			return null;
		}

		if (!this.MatchesPrecondition(enchants)){
			logger.Info("The item is missing some of the required enchantments.");
			return null;
		}

		if (enchants.method_57541() <= precondition.size()){
			logger.Info("The item does not have any enchantment besides the required ones.");
			return null;
		}

		return super.Walkthrough(stack, library, logger);
	}
}
