/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.VCitRegistries;
import fr.estecka.variantscit.VariantsCitMod;
import java.text.Normalizer;
import java.util.function.Function;
import net.minecraft.class_2960;

@FunctionalInterface
public interface IStringTransform
extends Function<String, String> {
    public static final IStringTransform NOOP = o -> o;
    public static final IStringTransform NULL = o -> null;
    public static final IStringTransform SANITIZE = IStringTransform.Sanitize("[^a-zA-Z0-9_.-/:]");
    public static final IStringTransform SANITIZE_PATH = IStringTransform.Sanitize("[^a-zA-Z0-9_.-/]");
    public static final IStringTransform SANITIZE_NAMESPACE = IStringTransform.Sanitize("[^a-zA-Z0-9_.-]");
    public static final IStringTransform SANITIZE_AUTO = IStringTransform::AutoSanitize;
    public static final IStringTransform LOWERCASE = String::toLowerCase;
    public static final Codec<IStringTransform> CODEC = VCitRegistries.TRANSFORMS.codec;
    @Deprecated
    public static final Codec<IStringTransform> LEGACY_CODEC = Codec.BOOL.xmap(lowercase -> lowercase != false ? LOWERCASE : NOOP, transform -> true).validate(_0 -> {
        VariantsCitMod.LOGGER.warn("The parameter `caseSensitive:true` is being deprecated. Use `transform:lowercase` instead.", new Object[0]);
        return DataResult.success((Object)_0);
    });

    public static IStringTransform Sanitize(String charset) {
        return input -> Normalizer.normalize(input, Normalizer.Form.NFD).replace(' ', '_').toLowerCase().replaceAll(charset, "");
    }

    public static String DiscardNamespace(String s) {
        int split = s.lastIndexOf(58);
        return split < 0 ? s : s.substring(split + 1);
    }

    public static String DiscardPath(String s) {
        int split = s.lastIndexOf(58);
        return split < 0 ? "" : s.substring(0, split);
    }

    public static String AutoSanitize(String input) {
        if (class_2960.method_12829((String)input) != null) {
            return input;
        }
        return (String)SANITIZE_PATH.apply(input);
    }
}

