/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit;

import fr.estecka.variantscit.ModuleLoader;
import fr.estecka.variantscit.VariantLibrary;
import fr.estecka.variantscit.VariantsCitMod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class ModelAggregator {
    public final Set<class_1091> modelsToLoad = new HashSet<class_1091>();
    public final Map<class_1091, class_2960> modelsToCreate = new HashMap<class_1091, class_2960>();

    public VariantLibrary CreateLibrary(ModuleLoader.ProtoModule prototype, class_3300 manager) {
        HashMap<class_2960, class_1091> allVariants = new HashMap<class_2960, class_1091>();
        HashMap<String, class_1091> allSpecials = new HashMap<String, class_1091>();
        String prefix = prototype.definition().modelPrefix();
        Optional<class_2960> modelParent = prototype.definition().modelParent();
        HashMap<String, class_2960> specials = new HashMap<String, class_2960>(prototype.definition().specialModels());
        prototype.definition().fallbackModel().ifPresent(fallback -> specials.put((String)null, (class_2960)fallback));
        Map<class_2960, class_1091> varModels = this.FindVariants(manager, "models", prefix, ".json");
        Map<String, class_1091> speModels = this.FindSpecials(manager, "models", specials, ".json");
        allVariants.putAll(varModels);
        allSpecials.putAll(speModels);
        this.modelsToLoad.addAll(varModels.values());
        this.modelsToLoad.addAll(speModels.values());
        if (modelParent.isPresent()) {
            Map<class_2960, class_1091> varTextures = this.FindVariants(manager, "textures", prefix, ".png");
            Map<String, class_1091> speTextures = this.FindSpecials(manager, "textures", specials, ".png");
            varModels.keySet().forEach(varTextures::remove);
            speModels.keySet().forEach(speTextures::remove);
            allVariants.putAll(varTextures);
            allSpecials.putAll(speTextures);
            varTextures.values().forEach(model -> this.AddModelToCreate((class_1091)model, (class_2960)modelParent.get()));
            speTextures.values().forEach(model -> this.AddModelToCreate((class_1091)model, (class_2960)modelParent.get()));
        }
        allSpecials.remove(null);
        return new VariantLibrary(prototype.definition().GetFallbackModelId(), allVariants, allSpecials);
    }

    private void AddModelToCreate(class_1091 model, class_2960 parent) {
        if (!this.modelsToCreate.containsKey(model)) {
            this.modelsToCreate.put(model, parent);
        } else if (!this.modelsToCreate.get(model).equals((Object)parent)) {
            VariantsCitMod.LOGGER.error("Conflicting definitions for model {}", (Object)model.comp_2875());
        }
    }

    private Map<class_2960, class_1091> FindVariants(class_3300 manager, String rootDirectory, String modelPrefix, String suffix) {
        HashMap<class_2960, class_1091> results = new HashMap<class_2960, class_1091>();
        String fullPrefix = rootDirectory + "/" + modelPrefix;
        String directory = fullPrefix.substring(0, fullPrefix.lastIndexOf(47));
        for (class_2960 fileId : manager.method_14488(directory, id -> id.method_12832().startsWith(fullPrefix) && id.method_12832().endsWith(suffix)).keySet()) {
            String namespace = fileId.method_12836();
            String modelName = fileId.method_12832();
            modelName = modelName.substring((rootDirectory + "/").length(), modelName.length() - suffix.length());
            String variantName = modelName.substring(modelPrefix.length());
            results.put(class_2960.method_60655((String)namespace, (String)variantName), VariantsCitMod.ModelIdFromResource(class_2960.method_60655((String)namespace, (String)modelName)));
        }
        return results;
    }

    private Map<String, class_1091> FindSpecials(class_3300 manager, String rootDirectory, Map<String, class_2960> requested, String suffix) {
        HashSet<class_2960> valid = new HashSet<class_2960>();
        Map<class_2960, class_2960> resourceIds = requested.values().stream().collect(Collectors.toMap(id -> id.method_45138(rootDirectory + "/").method_48331(suffix), id -> id));
        for (class_2960 fileId : manager.method_14488(rootDirectory, id -> resourceIds.keySet().contains(id)).keySet()) {
            valid.add(resourceIds.get(fileId));
        }
        return requested.entrySet().stream().filter(e -> valid.contains(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> VariantsCitMod.ModelIdFromResource((class_2960)e.getValue())));
    }
}

