/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.api.ICitModule;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public final class ModuleRegistry {
    private static final Map<class_2960, ModuleFactory> MODULE_TYPES = new HashMap<class_2960, ModuleFactory>();

    public static void Register(class_2960 type, MapCodec<? extends ICitModule> codec) {
        assert (codec != null);
        ModuleRegistry.RegisterFactory(type, json -> (ICitModule)((Pair)codec.decoder().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst());
    }

    public static void Register(class_2960 type, ICitModule module) {
        assert (module != null);
        ModuleRegistry.RegisterFactory(type, json -> module);
    }

    private static void RegisterFactory(class_2960 type, ModuleFactory factory) {
        assert (type != null);
        assert (factory != null);
        if (MODULE_TYPES.containsKey(type)) {
            throw new RuntimeException("Duplicate cit module registration for " + type.toString());
        }
        MODULE_TYPES.put(type, factory);
    }

    public static ICitModule CreateModule(class_2960 type, JsonObject customData) throws IllegalStateException {
        assert (type != null);
        if (!MODULE_TYPES.containsKey(type)) {
            throw new IllegalStateException("Unknown module type: " + type.toString());
        }
        return MODULE_TYPES.get(type).build(customData);
    }

    @FunctionalInterface
    private static interface ModuleFactory {
        public ICitModule build(JsonObject var1) throws IllegalStateException;
    }
}

