/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VCitRegistries;
import fr.estecka.variantscit.VariantsCitMod;
import java.text.Normalizer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;

@FunctionalInterface
public interface IStringTransform
extends Function<String, String> {
    public static final IStringTransform[] EMPTY = new IStringTransform[0];
    public static final IStringTransform[] AUTO = new IStringTransform[]{IStringTransform::AutoSanitize};
    public static final IStringTransform SANITIZE = IStringTransform.Sanitize("[^a-zA-Z0-9_.-/:]");
    public static final IStringTransform SANITIZE_PATH = IStringTransform.Sanitize("[^a-zA-Z0-9_.-/]");
    public static final IStringTransform SANITIZE_NAMESPACE = IStringTransform.Sanitize("[^a-zA-Z0-9_.-]");
    public static final Codec<IStringTransform> CODEC = VCitRegistries.TRANSFORMS.codec;
    public static final Codec<IStringTransform[]> ARRAY_CODEC = CodecUtil.OneOrMany(CODEC).xmap(list -> (IStringTransform[])list.toArray(IStringTransform[]::new), array -> List.of(array));
    @Deprecated
    public static final Codec<IStringTransform[]> LEGACY_CODEC = Codec.BOOL.xmap(lowercase -> {
        IStringTransform[] iStringTransformArray;
        if (lowercase.booleanValue()) {
            IStringTransform[] iStringTransformArray2 = new IStringTransform[1];
            iStringTransformArray = iStringTransformArray2;
            iStringTransformArray2[0] = String::toLowerCase;
        } else {
            iStringTransformArray = EMPTY;
        }
        return iStringTransformArray;
    }, transform -> true).validate(_0 -> {
        VariantsCitMod.LOGGER.warn("The parameter `caseSensitive:true` is being deprecated. Use `transform:lowercase` instead.");
        return DataResult.success((Object)_0);
    });

    public static String Transform(IStringTransform[] transforms, String input) {
        IStringTransform t;
        IStringTransform[] iStringTransformArray = transforms;
        int n = iStringTransformArray.length;
        for (int i = 0; i < n && (input = (String)(t = iStringTransformArray[i]).apply(input)) != null; ++i) {
        }
        return input;
    }

    public static IStringTransform Sanitize(String charset) {
        return input -> Normalizer.normalize(input, Normalizer.Form.NFD).replace(' ', '_').toLowerCase().replaceAll(charset, "");
    }

    public static String DiscardNamespace(String s) {
        int split = s.lastIndexOf(58);
        return split < 0 ? s : s.substring(split + 1);
    }

    public static String DiscardPath(String s) {
        int split = s.lastIndexOf(58);
        return split < 0 ? "" : s.substring(0, split);
    }

    public static String AutoSanitize(String input) {
        if (class_2960.method_12829((String)input) != null) {
            return input;
        }
        return (String)SANITIZE_PATH.apply(input);
    }
}

