/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.format.INbtInput;
import fr.estecka.variantscit.format.IStringTransform;
import fr.estecka.variantscit.format.NbtAdapter;
import fr.estecka.variantscit.format.NbtPath;
import fr.estecka.variantscit.format.properties.IStringProperty;
import fr.estecka.variantscit.format.properties.TransformableProperty;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public record ItemComponentProperty(class_9331<?> componentType, NbtAdapter nbtAdapter) implements IStringProperty
{
    public static final MapCodec<ItemComponentProperty> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_7923.field_49658.method_39673().fieldOf("componentType").forGetter(ItemComponentProperty::componentType), (App)NbtAdapter.MAPCODEC.forGetter(ItemComponentProperty::nbtAdapter)).apply((Applicative)builder, ItemComponentProperty::new));
    public static final Codec<TransformableProperty<ItemComponentProperty>> MONOSTRING_DECODER = Codec.STRING.flatXmap(ItemComponentProperty::MonostringParse, __ -> DataResult.error(() -> "Encoding not supported"));

    @Override
    public int GetPropertyHash(class_1799 stack) {
        Object cmp = stack.method_57824(this.componentType);
        return cmp != null ? cmp.hashCode() : 0;
    }

    @Override
    public Object GetReference(class_1799 stack) {
        return stack.method_57824(this.componentType);
    }

    @Override
    public String GetPropertyString(class_1799 stack) {
        class_2520 nbt = CodecUtil.GetComponentNbt(stack, this.componentType);
        if (nbt == null) {
            return null;
        }
        String result = this.nbtAdapter.ResolveData(nbt);
        return result;
    }

    private static DataResult<TransformableProperty<ItemComponentProperty>> MonostringParse(String input) {
        char c;
        int pathLocation;
        for (pathLocation = 0; pathLocation < input.length() && (c = input.charAt(pathLocation)) != '.' && class_2960.method_12831((char)c); ++pathLocation) {
        }
        String s_component = input.substring(0, pathLocation);
        String s_path = input.substring(pathLocation);
        DataResult r_path = !s_path.isEmpty() ? NbtPath.Parse(s_path) : DataResult.success((Object)NbtPath.IDENTITY);
        DataResult r_component = class_7923.field_49658.method_39673().decode((DynamicOps)class_2509.field_11560, (Object)class_2519.method_23256((String)s_component)).map(Pair::getFirst);
        if (r_path.isError()) {
            return r_path.map(__ -> null);
        }
        if (r_component.isError()) {
            return r_component.map(__ -> null);
        }
        NbtPath path = (NbtPath)r_path.getOrThrow();
        class_9331 component = (class_9331)r_component.getOrThrow();
        return DataResult.success(new TransformableProperty<ItemComponentProperty>(new ItemComponentProperty(component, new NbtAdapter(path, INbtInput.AUTO)), IStringTransform.AUTO, Optional.empty()));
    }
}

