/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules;

import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.format.properties.IStringProperty;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

abstract class AMultiComponentCachingModule
implements ICitModule {
    protected final boolean debug;
    private final IStringProperty[] properties;
    private final Int2ObjectMap<CacheEntry> hashToVariant = new Int2ObjectOpenHashMap();
    private final ReferenceQueue<Object> expiredComponents = new ReferenceQueue();

    protected AMultiComponentCachingModule(boolean debug, Stream<IStringProperty> properties) {
        this.debug = debug;
        this.properties = (IStringProperty[])properties.distinct().toArray(IStringProperty[]::new);
    }

    @Nullable
    public abstract class_2960 RecomputeItemModel(class_1799 var1, IVariantManager var2);

    @Override
    public final class_2960 GetItemModel(class_1799 stack, IVariantManager library) {
        this.ExpungeExpiredEntries();
        int hash = this.HashStack(stack);
        CacheEntry entry = (CacheEntry)this.hashToVariant.get(hash);
        if (entry == null) {
            entry = this.CreateEntry(hash, stack, library);
            if (this.debug) {
                VariantsCitMod.LOGGER.info("[multi_component] Cache size: {}; Id: {}", (Object)this.hashToVariant.size(), (Object)String.valueOf(entry.variant));
            }
        }
        return entry.variant;
    }

    private int HashStack(class_1799 stack) {
        int hash = 17;
        for (IStringProperty prop : this.properties) {
            hash = hash * 31 + prop.GetPropertyHash(stack);
        }
        return hash;
    }

    private CacheEntry CreateEntry(int hash, class_1799 stack, IVariantManager library) {
        class_2960 variant = this.RecomputeItemModel(stack, library);
        WeakReference[] weakRefs = new WeakReference[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            Object cmp = this.properties[i].GetReference(stack);
            if (cmp == null) continue;
            weakRefs[i] = new HashedWeakReference(hash, cmp, this.expiredComponents);
        }
        CacheEntry entry = new CacheEntry(variant, weakRefs);
        this.hashToVariant.put(hash, (Object)entry);
        return entry;
    }

    private void ExpungeExpiredEntries() {
        HashedWeakReference weakRef;
        while ((weakRef = (HashedWeakReference)this.expiredComponents.poll()) != null) {
            this.hashToVariant.remove(weakRef.hash);
        }
    }

    private record CacheEntry(class_2960 variant, WeakReference<?>[] components) {
    }

    private static class HashedWeakReference
    extends WeakReference<Object> {
        public final int hash;

        public HashedWeakReference(int hash, Object referent, ReferenceQueue<Object> queue) {
            super(referent, queue);
            this.hash = hash;
        }
    }
}

