/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.format.Substitution;
import fr.estecka.variantscit.format.properties.IStringProperty;
import fr.estecka.variantscit.modules.ASimpleMultiComponentCachingModule;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public class MultiComponentFormatModule
extends ASimpleMultiComponentCachingModule {
    public static final MapCodec<MultiComponentFormatModule> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(mod -> mod.debug), (App)Substitution.CODEC.fieldOf("format").forGetter(m -> m.format), (App)class_5699.method_53703(Substitution.VARNAME_CODEC, IStringProperty.CODEC).fieldOf("variables").forGetter(m -> m.varGetters)).apply((Applicative)builder, MultiComponentFormatModule::new));
    private final Substitution format;
    private final Map<String, IStringProperty> varGetters;

    public MultiComponentFormatModule(boolean debug, Substitution format, Map<String, IStringProperty> variables) {
        super(debug, variables.values().stream());
        this.format = format;
        this.varGetters = Map.copyOf(variables);
        this.format.MatchWarning(variables.keySet());
    }

    @Override
    public class_2960 RecomputeItemVariant(class_1799 stack) {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Map.Entry<String, IStringProperty> entry : this.varGetters.entrySet()) {
            String value = entry.getValue().GetPropertyString(stack);
            if (value == null) {
                return null;
            }
            variables.put(entry.getKey(), value);
        }
        String rawId = this.format.Substitute(variables);
        variables.clear();
        class_2960 id = class_2960.method_12829((String)rawId);
        if (this.debug) {
            VariantsCitMod.LOGGER.info("component_format: \"{}\" -> \"{}\"", (Object)this.format, (Object)rawId);
        }
        return id;
    }
}

