/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.estecka.variantscit.BakedModule;
import fr.estecka.variantscit.IItemModelProvider;
import fr.estecka.variantscit.ModuleRegistry;
import fr.estecka.variantscit.VariantLibrary;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.EquipVariantAggregator;
import fr.estecka.variantscit.reload.ItemVariantAggregator;
import fr.estecka.variantscit.reload.ModuleDefinition;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class ModuleLoader {
    public static Result ReloadModules(class_3300 manager) {
        Result result = new Result();
        ArrayList<MetaModule> modules = new ArrayList<MetaModule>();
        HashMap<class_2960, class_3298> resources = new HashMap<class_2960, class_3298>();
        resources.putAll(manager.method_14488("variant-cits/item", id -> id.method_12832().endsWith(".json")));
        ModuleLoader.ObsoletePathWarning(resources);
        resources.putAll(manager.method_14488("variants-cit/item", id -> id.method_12832().endsWith(".json")));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                class_2960 moduleId = ModuleLoader.ModuleIdFromResourceId((class_2960)entry.getKey());
                ProtoModule prototype = (ProtoModule)ModuleLoader.DefinitionFromResource((class_3298)entry.getValue()).getOrThrow();
                List<EModuleContext> contexts = prototype.definition().GetEnabledContexts(moduleId);
                if (contexts.isEmpty()) {
                    VariantsCitMod.LOGGER.warn("Ignored VCIT module with no context: {}", (Object)moduleId);
                    continue;
                }
                Set targets = prototype.definition.targets().map(ModuleLoader::ItemsFromTarget).orElseGet(() -> ModuleLoader.ItemsFromModuleId(moduleId));
                if (targets.isEmpty()) {
                    VariantsCitMod.LOGGER.warn("Skipped VCIT module with no valid item: {}", (Object)moduleId);
                    continue;
                }
                if (prototype.definition.modelPrefix().isEmpty()) {
                    VariantsCitMod.LOGGER.error("VCIT module `{}` has an empty model prefix. This can lead to unexpected behaviours and performance loss.", (Object)moduleId);
                }
                ICitModule moduleLogic = ModuleRegistry.CreateModule(prototype.definition.type(), prototype.parameters);
                VariantLibrary itemLibrary = null;
                VariantLibrary equipLibrary = null;
                for (EModuleContext c : contexts) {
                    switch (c) {
                        case ITEM_MODEL: {
                            itemLibrary = result.itemAggregator.CreateLibrary(prototype.definition, manager);
                            break;
                        }
                        case EQUIPPABLE: {
                            equipLibrary = result.equipAggregator.CreateLibrary(prototype.definition, manager);
                        }
                    }
                }
                MetaModule meta = new MetaModule(moduleId, prototype.definition.priority(), targets, Optional.ofNullable(itemLibrary), Optional.ofNullable(equipLibrary), moduleLogic);
                modules.add(meta);
            }
            catch (IllegalStateException e) {
                VariantsCitMod.LOGGER.error("Error in VCIT module {}: {}", entry.getKey(), (Object)e);
            }
        }
        modules.sort((a, b) -> -Integer.compare(a.priority(), b.priority()));
        ModuleLoader.BakeModules(result, modules);
        return result;
    }

    private static void ObsoletePathWarning(Map<class_2960, class_3298> resources) {
        if (!resources.isEmpty()) {
            Object names = "";
            for (class_2960 id : resources.keySet()) {
                names = (String)names + " ";
                names = (String)names + ModuleLoader.ModuleIdFromResourceId(id).toString();
            }
            VariantsCitMod.LOGGER.warn("Some VCIT modules are using the old mispelled directory `variant-cits`, those should be moved to `variants-cit` instead:{}", names);
        }
    }

    private static Set<class_1792> ItemsFromTarget(List<class_2960> targets) {
        HashSet<class_1792> result = new HashSet<class_1792>();
        targets.stream().map(id -> class_7923.field_41178.method_10223(id)).filter(Optional::isPresent).map(opt -> (class_1792)((class_6880.class_6883)opt.get()).comp_349()).forEach(result::add);
        return result;
    }

    private static Set<class_1792> ItemsFromModuleId(class_2960 moduleId) {
        class_2960 itemId = ModuleLoader.ItemIdFromModuleId(moduleId);
        if (class_7923.field_41178.method_10250(itemId)) {
            return Set.of((class_1792)((class_6880.class_6883)class_7923.field_41178.method_10223(itemId).get()).comp_349());
        }
        return Set.of();
    }

    private static class_2960 ItemIdFromModuleId(class_2960 resource) {
        String path = resource.method_12832();
        path = path.substring("item/".length());
        return class_2960.method_60655((String)resource.method_12836(), (String)path);
    }

    private static class_2960 ModuleIdFromResourceId(class_2960 resource) {
        String path = resource.method_12832();
        path = path.substring("variant-cits/".length(), path.length() - ".json".length());
        return class_2960.method_60655((String)resource.method_12836(), (String)path);
    }

    private static DataResult<ProtoModule> DefinitionFromResource(class_3298 resource) {
        JsonObject json;
        try {
            json = class_3518.method_15255((Reader)resource.method_43039());
        }
        catch (JsonParseException | IOException e) {
            return DataResult.error(((Exception)e)::toString);
        }
        DataResult dataResult = ModuleDefinition.CODEC.decoder().decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (dataResult.isError()) {
            return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)dataResult.error().get())).message());
        }
        try {
            ModuleDefinition definition = (ModuleDefinition)((Pair)dataResult.getOrThrow()).getFirst();
            JsonObject parameters = json.getAsJsonObject("parameters");
            if (parameters == null) {
                parameters = new JsonObject();
            }
            return DataResult.success((Object)new ProtoModule(definition, parameters));
        }
        catch (ClassCastException | IllegalStateException e) {
            return DataResult.error(e::toString);
        }
    }

    public static void BakeModules(Result result, List<MetaModule> modules) {
        HashMap<class_1792, List<BakedModule>> itemModules = new HashMap<class_1792, List<BakedModule>>();
        HashMap<class_1792, List<BakedModule>> equipModules = new HashMap<class_1792, List<BakedModule>>();
        for (MetaModule meta : modules) {
            if (meta.itemLibrary().isPresent()) {
                ModuleLoader.BakeModuleContext("item_model", meta, meta.itemLibrary().get(), itemModules);
            }
            if (!meta.equipLibrary().isPresent()) continue;
            ModuleLoader.BakeModuleContext("equippable", meta, meta.equipLibrary().get(), equipModules);
        }
        ModuleLoader.BakeItem(result.itemModules, itemModules);
        ModuleLoader.BakeItem(result.equipModules, equipModules);
    }

    private static void BakeModuleContext(String contextName, MetaModule meta, VariantLibrary lib, Map<class_1792, List<BakedModule>> output) {
        if (lib.isEmpty()) {
            VariantsCitMod.LOGGER.warn("Empty {} VCIT module {}", (Object)contextName, (Object)meta.id());
        } else {
            VariantsCitMod.LOGGER.info("Found {} {} variants for VCIT module {}", new Object[]{lib.GetVariantCount(), contextName, meta.id()});
        }
        for (class_1792 itemType : meta.targets()) {
            output.computeIfAbsent(itemType, __ -> new ArrayList()).add(new BakedModule(lib, meta.logic()));
        }
    }

    private static void BakeItem(Map<class_1792, IItemModelProvider> result, Map<class_1792, List<BakedModule>> moduleListPerItem) {
        for (Map.Entry<class_1792, List<BakedModule>> entry : moduleListPerItem.entrySet()) {
            result.put(entry.getKey(), IItemModelProvider.OfList(entry.getValue()));
        }
    }

    public static class Result {
        public final Map<class_1792, IItemModelProvider> itemModules = new HashMap<class_1792, IItemModelProvider>();
        public final Map<class_1792, IItemModelProvider> equipModules = new HashMap<class_1792, IItemModelProvider>();
        public final ItemVariantAggregator itemAggregator = new ItemVariantAggregator();
        public final EquipVariantAggregator equipAggregator = new EquipVariantAggregator();
    }

    record ProtoModule(ModuleDefinition definition, JsonObject parameters) {
    }

    public record MetaModule(class_2960 id, int priority, Set<class_1792> targets, Optional<VariantLibrary> itemLibrary, Optional<VariantLibrary> equipLibrary, ICitModule logic) {
    }
}

