package fr.estecka.variantscit.modules.impl;

import java.util.WeakHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.api.ISimpleCitModule;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.commands.CommandLogger;

/**
 * Optimization for deterministic modules that may require expensive computation
 * upon a single item component.
 * 
 * The cache in this version is allowed to survive resource reloads.
 */
abstract class ASimpleComponentCachingModule<T>
implements ISimpleCitModule
{
	protected final class_9331<T> componentType;

	/*
	 * The lifetime of each entry  is roughly equivalent  to the lifetime of the
	 * associated  item stack's  component. Item components  are supposed  to be
	 * immutable, so a variant  should never need  to be recomputed  for a given
	 * component.
	 */
	final WeakHashMap<T, @Nullable class_2960> cachedVariants = new WeakHashMap<>();

	public ASimpleComponentCachingModule(class_9331<T> component){
		this.componentType = component;
	}


	@Override
	public final class_2960 GetItemVariant(class_1799 stack){
		T component = stack.method_58694(this.componentType);
		if (component == null)
			return null;

		/**
		 * Do  not  use  computeIfAbsent! It would  attempt  to  recompute  null
		 * values, which are valid to cache.
		 */
		if (!cachedVariants.containsKey(component))
			cachedVariants.put(component, GetVariantForComponent(component));

		return cachedVariants.get(component);
	}

	@Override
	public @Nullable class_2960 Walkthrough(class_1799 stack, IVariantManager library, CommandLogger logger) {
		T component = stack.method_58694(this.componentType);
		if (component == null)
			return null;

		return library.GetVariantModel(GetVariantForComponent(component));
	}

	public abstract class_2960 GetVariantForComponent(T component);
}
