/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.transforms;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.format.IStringTransform;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public record FilterlistTransform(Set<String> filter, boolean isWhiteList) implements IStringTransform
{
    public static final MapCodec<FilterlistTransform> MAPCODEC_WHITELIST = FilterlistTransform.CreateMapCodec(true);
    public static final MapCodec<FilterlistTransform> MAPCODEC_BLACKLIST = FilterlistTransform.CreateMapCodec(false);

    public static final MapCodec<FilterlistTransform> CreateMapCodec(boolean isWhiteList) {
        String listName = isWhiteList ? "whitelist" : "blacklist";
        return Codec.STRING.listOf().fieldOf(listName).xmap(HashSet::new, List::copyOf).xmap(set -> new FilterlistTransform((Set<String>)set, isWhiteList), FilterlistTransform::filter);
    }

    @Override
    public String apply(String input) {
        if (this.isWhiteList == this.filter.contains(input)) {
            return input;
        }
        return null;
    }
}

