/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.commands.CommandLogger;
import fr.estecka.variantscit.format.Substitution;
import fr.estecka.variantscit.format.properties.IStringProperty;
import fr.estecka.variantscit.format.properties.TransformableProperty;
import fr.estecka.variantscit.modules.impl.ASimpleMultiComponentCachingModule;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class MultiComponentFormatModule
extends ASimpleMultiComponentCachingModule {
    public static final MapCodec<MultiComponentFormatModule> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(mod -> mod.debug), (App)Substitution.CODEC.fieldOf("format").forGetter(m -> m.format), (App)class_5699.method_53703(Substitution.VARNAME_CODEC, IStringProperty.CODEC).fieldOf("variables").forGetter(m -> m.varGetters)).apply((Applicative)builder, MultiComponentFormatModule::new));
    private final Substitution format;
    private final Map<String, IStringProperty> varGetters;

    public MultiComponentFormatModule(boolean debug, Substitution format, Map<String, IStringProperty> variables) {
        super(debug, variables.values().stream());
        this.format = format;
        this.varGetters = Map.copyOf(variables);
        this.format.MatchWarning(variables.keySet());
    }

    @Override
    public class_2960 RecomputeItemVariant(class_1799 stack) {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (this.debug) {
            VariantsCitMod.LOGGER.info("[component_format] {}", this.format);
        }
        for (Map.Entry<String, IStringProperty> entry : this.varGetters.entrySet()) {
            String value = entry.getValue().GetPropertyString(stack);
            if (this.debug) {
                VariantsCitMod.LOGGER.info("\t${{}} -> {}", entry.getKey(), value);
            }
            if (value == null) {
                return null;
            }
            variables.put(entry.getKey(), value);
        }
        String rawId = this.format.Substitute(variables);
        if (this.debug) {
            VariantsCitMod.LOGGER.info("\t= {}", rawId);
        }
        variables.clear();
        class_2960 id = class_2960.method_12829((String)rawId);
        return id;
    }

    @Override
    @Nullable
    public class_2960 Walkthrough(class_1799 stack, IVariantManager library, CommandLogger logger) {
        boolean failure = false;
        HashMap<String, String> variables = new HashMap<String, String>();
        logger.Info("Format: \"{}\"", CommandLogger.PackData(this.format));
        for (Map.Entry<String, IStringProperty> entry : this.varGetters.entrySet()) {
            String raw = TransformableProperty.GetRaw(entry.getValue()).GetPropertyString(stack);
            String transformed = entry.getValue().GetPropertyString(stack);
            logger.Info("${{}}:", CommandLogger.PackData(entry.getKey()));
            logger.Info("- Raw data: {}", CommandLogger.ItemData(raw, "Missing or invalid"));
            logger.Info("- Transformed: {}", CommandLogger.ItemData(transformed));
            failure |= transformed == null;
            variables.put(entry.getKey(), transformed);
        }
        if (failure) {
            logger.Info("Some data could not be processed.");
        } else {
            logger.Info("Formatted variant: {}", CommandLogger.ItemData(this.format.Substitute(variables)));
        }
        return this.RecomputeItemModel(stack, library);
    }
}

