/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.libraries;

import fr.estecka.variantscit.commands.CommandLogger;
import fr.estecka.variantscit.modules.IModuleBaker;
import fr.estecka.variantscit.modules.libraries.GenericBakedModule;
import fr.estecka.variantscit.modules.libraries.IDebuggableLibrary;
import fr.estecka.variantscit.modules.libraries.IGenericCitModule;
import fr.estecka.variantscit.modules.libraries.ILinearLibrary;
import fr.estecka.variantscit.modules.libraries.LinearSnapMap;
import fr.estecka.variantscit.modules.libraries.VariantLibrary;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LinearLibrary
implements ILinearLibrary,
IDebuggableLibrary<ILinearLibrary> {
    protected final String namespace;
    protected final class_2960 fallback;
    protected final LinearSnapMap<class_2960> modelLine = new LinearSnapMap();

    public LinearLibrary(VariantLibrary variantLibrary, String allowedNamespace) {
        this.fallback = variantLibrary.fallbackModel();
        this.namespace = allowedNamespace;
        for (Map.Entry<class_2960, class_2960> variant : variantLibrary.variantModels().entrySet()) {
            if (!variant.getKey().method_12836().equals(allowedNamespace)) continue;
            try {
                int magnitude = Integer.parseInt(variant.getKey().method_12832());
                this.modelLine.AddEntry(magnitude, variant.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private class_2960 Fallback(@Nullable class_2960 id) {
        return id != null ? id : this.fallback;
    }

    @Override
    public class_2960 GetOrLesser(int magnitude) {
        return this.Fallback(this.modelLine.GetClosestValue(magnitude, -1));
    }

    @Override
    public class_2960 GetOrGreater(int magnitude) {
        return this.Fallback(this.modelLine.GetClosestValue(magnitude, 1));
    }

    public static <M extends ILinearCitModule> IModuleBaker<M> GetBaker() {
        return new IModuleBaker<M>(){

            @Override
            public boolean AcceptVariant(class_2960 variantId, M parameters) {
                if (!variantId.method_12836().equals(parameters.GetNamespace())) {
                    return false;
                }
                try {
                    Integer.parseUnsignedInt(variantId.method_12832());
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }

            public GenericBakedModule<ILinearLibrary> Bake(VariantLibrary library, M linearModule) {
                return new GenericBakedModule<ILinearLibrary>(new LinearLibrary(library, linearModule.GetNamespace()), (IGenericCitModule<ILinearLibrary>)linearModule);
            }
        };
    }

    @Override
    public void Summary(CommandLogger logger) {
        logger.Info("This module handles {} variants.", this.modelLine.size());
    }

    @Override
    public void Dump(CommandLogger logger) {
        if (this.modelLine.size() <= 0) {
            logger.Info("This module does not have any variant.");
        } else {
            for (LinearSnapMap.Entry<class_2960> entry : this.modelLine) {
                logger.Info("{} -> {}", CommandLogger.ItemData(entry.magnitude()), CommandLogger.PackData(entry.value()));
            }
        }
    }

    @Override
    public IDebuggableLibrary.Snitch<ILinearLibrary> CreateSnitch(CommandLogger logger) {
        return new SnitchingLinearLibrary(logger);
    }

    private class SnitchingLinearLibrary
    extends IDebuggableLibrary.Snitch<ILinearLibrary>
    implements ILinearLibrary {
        public SnitchingLinearLibrary(CommandLogger logger) {
            super(logger);
        }

        @Override
        public class_2960 GetOrGreater(int magnitude) {
            class_2960 r = LinearLibrary.this.GetOrGreater(magnitude);
            this.LogGet(magnitude, r != null, "greater", LinearLibrary.this.namespace);
            return r;
        }

        @Override
        public class_2960 GetOrLesser(int magnitude) {
            class_2960 r = LinearLibrary.this.GetOrLesser(magnitude);
            this.LogGet(magnitude, r != null, "lesser", LinearLibrary.this.namespace);
            return r;
        }

        private void LogGet(int magnitude, boolean exists, String textBias, String namespace) {
            this.OnTriedVariant(class_2960.method_60655((String)namespace, (String)String.valueOf(magnitude)), exists);
            this.logger.Info("Getting model {} or {}", CommandLogger.ItemData(magnitude), textBias);
        }
    }

    public static interface ILinearCitModule
    extends IGenericCitModule<ILinearLibrary> {
        public String GetNamespace();
    }
}

