/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit;

import fr.estecka.variantscit.VariantsCitMod;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9331;

public class MultiPropertyCache {
    public final boolean debug;
    private final ICachableItemProperty[] properties;
    private final Int2ObjectMap<CacheEntry> hashToVariant = new Int2ObjectOpenHashMap();
    private final ReferenceQueue<Object> expiredComponents = new ReferenceQueue();

    public MultiPropertyCache(boolean debug, Stream<? extends ICachableItemProperty> properties) {
        this.debug = debug;
        this.properties = (ICachableItemProperty[])properties.distinct().toArray(ICachableItemProperty[]::new);
    }

    public MultiPropertyCache(boolean debug, class_9331<?> component) {
        this(debug, Stream.of(MultiPropertyCache.ComponentProperty(component)));
    }

    private static ICachableItemProperty ComponentProperty(final class_9331<?> type) {
        return new ICachableItemProperty(){

            @Override
            public int GetPropertyHash(class_1799 stack) {
                return stack.method_58694(type).hashCode();
            }

            @Override
            public Object GetReference(class_1799 stack) {
                return stack.method_58694(type);
            }
        };
    }

    public class_2960 ComputeIfAbsent(class_1799 stack, Function<class_1799, class_2960> computer) {
        this.ExpungeExpiredEntries();
        int hash = this.HashStack(stack);
        CacheEntry entry = (CacheEntry)this.hashToVariant.get(hash);
        if (entry == null) {
            class_2960 variant = computer.apply(stack);
            entry = this.CreateEntry(hash, stack, variant);
            if (this.debug) {
                VariantsCitMod.LOGGER.info("Cache size: {}; Latest Model Id: {}", this.hashToVariant.size(), String.valueOf(entry.variant));
            }
        }
        return entry.variant;
    }

    private int HashStack(class_1799 stack) {
        int hash = 17;
        for (ICachableItemProperty prop : this.properties) {
            hash = hash * 31 + prop.GetPropertyHash(stack);
        }
        return hash;
    }

    private CacheEntry CreateEntry(int hash, class_1799 stack, class_2960 variant) {
        WeakReference[] weakRefs = new WeakReference[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            Object ref = this.properties[i].GetReference(stack);
            if (ref == null) continue;
            weakRefs[i] = new HashedWeakReference(hash, ref, this.expiredComponents);
        }
        CacheEntry entry = new CacheEntry(variant, weakRefs);
        this.hashToVariant.put(hash, (Object)entry);
        return entry;
    }

    private void ExpungeExpiredEntries() {
        HashedWeakReference weakRef;
        while ((weakRef = (HashedWeakReference)this.expiredComponents.poll()) != null) {
            this.hashToVariant.remove(weakRef.hash);
        }
    }

    public static interface ICachableItemProperty {
        public int GetPropertyHash(class_1799 var1);

        public Object GetReference(class_1799 var1);
    }

    private record CacheEntry(class_2960 variant, WeakReference<?>[] components) {
    }

    private static class HashedWeakReference
    extends WeakReference<Object> {
        public final int hash;

        public HashedWeakReference(int hash, Object referent, ReferenceQueue<Object> queue) {
            super(referent, queue);
            this.hash = hash;
        }
    }
}

