package fr.estecka.variantscit.properties;

import org.jetbrains.annotations.Nullable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_638;
import net.minecraft.class_9279;
import net.minecraft.class_9331;


public class NbtNumberProperty
implements class_1800
{
	static public final MapCodec<NbtNumberProperty> CreateCodec(class_9331<class_9279> componentType){
		return RecordCodecBuilder.mapCodec(builder->builder
			.group(
				Codec.STRING.fieldOf("nbtPath").forGetter(s->"")
			)
			.apply(builder, (a)->new NbtNumberProperty(componentType, a))
		);
	}

	/**
	 * TODO: implement proper getter for the codec.
	 */
	private final String[] path;
	private final class_9331<class_9279> dataType;

	private NbtNumberProperty(class_9331<class_9279> dataType, String path) {
		this.dataType = dataType;
		this.path = ParsePath(path);
	}

	@Override
	public MapCodec<NbtNumberProperty> method_65643(){
		return CreateCodec(dataType);
	}

	@Override
	public float method_65644(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed){
		return GetValueForComponent(stack.method_57824(dataType));
	}


	public float GetValueForComponent(class_9279 component){
		class_2520 nbt;
		if (component==null || (nbt=component.method_57463())==null)
			return 0;

		for (int i=0; i<path.length; ++i)
		if  (nbt instanceof class_2487 compound)
			nbt = compound.method_10580(path[i]);
		else
			return 0;

		if (nbt instanceof class_2514 num)
			return num.method_10700();
		else
			return 0;
	}

	static private String[] ParsePath(String rawPath)
	throws IllegalStateException
	{
		String[] result = rawPath.split("\\.");

		for (String s : result)
			if (s.isEmpty())
				throw new IllegalStateException("Malformatted path: "+rawPath);

		return result;
	}
}
