package fr.estecka.variantscit;

import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_10443;
import net.minecraft.class_10482;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_9334;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.reload.ModuleLoader;
import fr.estecka.variantscit.modulebakers.IBakedModule;
import fr.estecka.variantscit.properties.*;
import fr.estecka.variantscit.selectors.*;


public class VariantsCitMod
implements ClientModInitializer
{
	static public final String MODID = "variants-cit";
	public static final LabelledLogger LOGGER = new LabelledLogger();

	static public int reloadcount = 0;
	static public final EquippableCache EQUIPABLES = new EquippableCache();
	static private Map<class_1792, IBakedModule> ITEM_MODULES  = new HashMap<>();
	static private Map<class_1792, IBakedModule> EQUIP_MODULES = new HashMap<>();

	static public @Nullable IBakedModule GetItemModule(class_1792 itemType){
		return ITEM_MODULES.get(itemType);
	}
	static public @Nullable IBakedModule GetEquipmentModule(class_1792 itemType){
		return EQUIP_MODULES.get(itemType);
	}

	@Override
	public void onInitializeClient(){
		class_10482.field_55408.method_65325(class_2960.method_60655(MODID, "block_entity_data"), NbtNumberProperty.CreateCodec(class_9334.field_49611));
		class_10482.field_55408.method_65325(class_2960.method_60655(MODID, "bucket_entity_data"), NbtNumberProperty.CreateCodec(class_9334.field_49610));
		class_10482.field_55408.method_65325(class_2960.method_60655(MODID, "custom_data"), NbtNumberProperty.CreateCodec(class_9334.field_49628));
		class_10482.field_55408.method_65325(class_2960.method_60655(MODID, "entity_data"), NbtNumberProperty.CreateCodec(class_9334.field_49609));
		class_10482.field_55408.method_65325(class_2960.method_60655(MODID, "stored_enchantment_level"), EnchantedBookLevelPredicate.CODEC);
		class_10443.field_55336.method_65325(class_2960.method_60656("range_dispatch"), DynamicRangeDispatchUnbaked.CODEC);
	}

	static public void OnResourceReload(ModuleLoader.Result result){
		++reloadcount;
		EQUIPABLES.Clear();
		ITEM_MODULES  = result.itemModules;
		EQUIP_MODULES = result.equipModules;
	}

}
