package fr.estecka.variantscit.modules;

import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.api.ISimpleCitModule;

/**
 * @deprecated  Kept  around  for  future  reference,  but  mostly  replaced  by
 * {@link ASimpleMultiComponentCachingModule }. This  implementation is working,
 * but is  a little too  trigger happy  on recomputating caches; simply using an
 * item will cause it to be recomputed.
 */
@Deprecated
abstract class ASimpleItemCachingModule
implements ISimpleCitModule
{
	protected final boolean debug;
	private final WeakHashMap<class_1799, CacheEntry> cache = new WeakHashMap<>();

	protected record CacheEntry(@Nullable class_2960 variant, Predicate<class_1799> isDirty) {}

	protected ASimpleItemCachingModule(boolean debug){
		this.debug = debug;
	}

	@Override
	public final class_2960 GetItemVariant(class_1799 stack){
		CacheEntry entry = this.cache.get(stack);

		if (entry == null || entry.isDirty.test(stack)){
			entry = new CacheEntry(this.RecomputeItemVariant(stack), this.IsDirty(stack).and(ItemTypeValidator(stack)));
			cache.put(stack, entry);
			if (debug)
				VariantsCitMod.LOGGER.info("[ASimpleItem] Cache size: {}; Variant id: {}", cache.size(), entry.variant);
		}

		return entry.variant;
	}

	static private Predicate<class_1799> ItemTypeValidator(class_1799 stack){
		final class_1792 type =  stack.method_7909();
		return futureStack -> futureStack.method_7909() == type;
	}

	/**
	 * @param stack An item stack, in the state it was the last time its variant
	 * was computed.
	 * @return A predicate that checks whether an item stack's variant should be
	 * recomputed. Occasional  false-positives  are  tolerated; accuracy  can be
	 * traded off for performance.
	 */
	public abstract Predicate<class_1799> IsDirty(class_1799 stack);

	public abstract @Nullable class_2960 RecomputeItemVariant(class_1799 stack);
}
