package fr.estecka.variantscit.modules;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.format.Substitution;
import fr.estecka.variantscit.format.properties.IStringProperty;

public class MultiComponentFormatModule
extends ASimpleMultiComponentCachingModule
{
	static public final MapCodec<MultiComponentFormatModule> CODEC = RecordCodecBuilder.mapCodec(builder->builder
		.group(
			Codec.BOOL.fieldOf("debug").orElse(false).forGetter(mod -> mod.debug),
			Substitution.CODEC.fieldOf("format").forGetter(m->m.format),
			class_5699.method_53703(Substitution.VARNAME_CODEC, IStringProperty.CODEC).fieldOf("variables").forGetter(m->m.varGetters)
		)
		.apply(builder, MultiComponentFormatModule::new)
	);

	private final Substitution format;
	private final Map<String, IStringProperty> varGetters;

	public MultiComponentFormatModule(boolean debug, Substitution format, Map<String,IStringProperty> variables){
		super(debug, variables.values().stream());
		this.format = format;
		this.varGetters = Map.copyOf(variables);

		this.format.MatchWarning(variables.keySet());
	}

	@Override
	public class_2960 RecomputeItemVariant(class_1799 stack){
		Map<String,String> variables = new HashMap<>();

		if (debug)
			VariantsCitMod.LOGGER.info("[component_format] {}", this.format);

		for (var entry : this.varGetters.entrySet()){
			String value = entry.getValue().GetPropertyString(stack);
			if (debug)
				VariantsCitMod.LOGGER.info("\t${{}} -> {}", entry.getKey(), value);
			if (value == null)
				return null;

			variables.put(entry.getKey(), value);
		}

		String rawId = this.format.Substitute(variables);
		if (debug)
			VariantsCitMod.LOGGER.info("\t= {}", rawId);
		variables.clear();
		class_2960 id = class_2960.method_12829(rawId);
		return id;
	}
}
