/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.LinearSnapMap;
import fr.estecka.variantscit.MultiPropertyCache;
import fr.estecka.variantscit.VariantLibrary;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.modulebakers.IBakedModule;
import fr.estecka.variantscit.modulebakers.IModuleBaker;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9331;

public class EnchantmentVectorModule
implements IBakedModule {
    private static final MapCodec<Pattern> REGEX_MAPCODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtil.NONEMPTY_STRING.validate(EnchantmentVectorModule::ValidateSeparator).optionalFieldOf("enchantSeparator", (Object)"__").forGetter(_0 -> ""), (App)Codec.STRING.validate(EnchantmentVectorModule::ValidateSeparator).optionalFieldOf("levelSeparator").forGetter(_0 -> Optional.empty()), (App)Codec.BOOL.optionalFieldOf("optionalLevel", (Object)false).forGetter(_0 -> false)).apply((Applicative)builder, EnchantmentVectorModule::BakeRegex));
    public static final Codec<ToIntFunction<EnchantVector>> NORM_CODEC = CodecUtil.Enum(Codec.STRING, Map.of("taxicab", EnchantVector::TaxicabMagnitude, "euclidian", EnchantVector::EuclidianSquaredMagnitude, "maximum", EnchantVector::Maximum, "dimension", EnchantVector::Dimensionality));
    private static final List<ToIntFunction<EnchantVector>> DEFAULT_ORDERING = List.of(EnchantVector::TaxicabMagnitude, EnchantVector::Dimensionality);
    public static final MapCodec<Parameters> PARAM_MAPCODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("bakingDebug", (Object)false).forGetter(Parameters::bakingDebug), (App)Codec.BOOL.optionalFieldOf("runtimeDebug", (Object)false).forGetter(Parameters::runtimeDebug), (App)NORM_CODEC.listOf(1, 4).optionalFieldOf("ordering", DEFAULT_ORDERING).forGetter(Parameters::ordering), (App)REGEX_MAPCODEC.forGetter(Parameters::vectorRegex), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)class_2960.field_25139).optionalFieldOf("enchantAliases", Map.of()).forGetter(Parameters::aliases), (App)CodecUtil.IDENTIFIER_NAMESPACE.optionalFieldOf("namespace", (Object)"minecraft").forGetter(Parameters::namespace)).apply((Applicative)builder, Parameters::new));
    private final class_9331<class_9304> componentType;
    private final MultiPropertyCache cache;
    private final class_2960 fallback;
    private final VectorSpace vectorSpace;
    private final LinearSnapMap<VariantEntry> modelLine;
    private final ToIntFunction<EnchantVector> magnitudeGetter;

    public static IModuleBaker<Parameters> GetBaker(final class_9331<class_9304> component) {
        return new IModuleBaker<Parameters>(){

            @Override
            public IBakedModule Bake(VariantLibrary library, Parameters parameters) {
                return new EnchantmentVectorModule(library, parameters, (class_9331<class_9304>)component);
            }

            @Override
            public boolean AcceptVariant(class_2960 variantId, Parameters parameters) {
                if (!parameters.namespace.equals(variantId.method_12836())) {
                    return false;
                }
                if (!parameters.vectorRegex.matcher(variantId.method_12832()).matches()) {
                    VariantsCitMod.LOGGER.warn("Not a valid enchantment set: {}", variantId.method_12832());
                    return false;
                }
                return true;
            }
        };
    }

    public EnchantmentVectorModule(VariantLibrary variantLibrary, Parameters params, class_9331<class_9304> component) {
        Object msg;
        VariantsCitMod.LOGGER.PushLabel("enchantment_vector");
        this.componentType = component;
        this.fallback = variantLibrary.fallbackModel();
        this.cache = new MultiPropertyCache(params.runtimeDebug, this.componentType);
        this.magnitudeGetter = params.ordering.get(0);
        this.modelLine = EnchantmentVectorModule.OrderedSnapMap(params.ordering);
        HashMap<class_2960, Integer> enchant2MaxLevel = new HashMap<class_2960, Integer>();
        HashMap<Map<class_2960, Integer>, class_2960> vector2Model = new HashMap<Map<class_2960, Integer>, class_2960>();
        HashSet<String> duplicateIds = new HashSet<String>();
        for (Map.Entry<class_2960, class_2960> entry : variantLibrary.variantModels().entrySet()) {
            Optional<Map<class_2960, Integer>> optional;
            if (!entry.getKey().method_12836().equals(params.namespace) || !(optional = EnchantmentVectorModule.VariantId2Map(params.vectorRegex, entry.getKey(), params.aliases)).isPresent()) continue;
            Map<class_2960, Integer> enchants = optional.get();
            if (vector2Model.containsKey(enchants)) {
                duplicateIds.add(entry.getKey().method_12832());
                continue;
            }
            vector2Model.put(enchants, entry.getValue());
            for (Map.Entry<class_2960, Integer> e : enchants.entrySet()) {
                if (e.getValue() <= enchant2MaxLevel.getOrDefault(e.getKey(), 0)) continue;
                enchant2MaxLevel.put(e.getKey(), e.getValue());
            }
        }
        if (params.bakingDebug) {
            msg = "These enchantments were detected in the CITs. If this looks wrong, check your filenames and your aliases:";
            for (class_2960 class_29602 : enchant2MaxLevel.keySet()) {
                msg = (String)msg + "\n" + class_29602.toString();
            }
            VariantsCitMod.LOGGER.info((String)msg, new Object[0]);
        }
        if (!duplicateIds.isEmpty()) {
            msg = "The following variant IDs describe duplicate enchantment sets and will be ignored:";
            for (String string : duplicateIds) {
                msg = (String)msg + "\n" + string;
            }
            VariantsCitMod.LOGGER.warn((String)msg, new Object[0]);
        }
        this.vectorSpace = new VectorSpace(enchant2MaxLevel);
        for (Map.Entry<Object, Object> entry : vector2Model.entrySet()) {
            EnchantVector enchantVector = this.vectorSpace.VectorFromMap((Map)entry.getKey());
            this.modelLine.AddEntry(this.magnitudeGetter.applyAsInt(enchantVector), new VariantEntry(enchantVector, (class_2960)entry.getValue()));
        }
        VariantsCitMod.LOGGER.PopLabel();
    }

    private static LinearSnapMap<VariantEntry> OrderedSnapMap(List<ToIntFunction<EnchantVector>> ordering) {
        if (ordering.size() < 2) {
            return new LinearSnapMap<VariantEntry>();
        }
        Comparator[] tiebreaker = new Comparator[ordering.size() - 1];
        for (int i = 1; i < ordering.size(); ++i) {
            tiebreaker[i - 1] = Comparator.comparing(VariantEntry::vector, Comparator.comparingInt(ordering.get(i)));
        }
        return new LinearSnapMap<VariantEntry>((a, b) -> {
            for (Comparator comp : tiebreaker) {
                int r = comp.compare(a, b);
                if (r == 0) continue;
                return r;
            }
            return 0;
        });
    }

    private static Optional<Map<class_2960, Integer>> VariantId2Map(Pattern regex, class_2960 variantId, Map<class_2960, class_2960> aliases) {
        HashMap<class_2960, Integer> vector = new HashMap<class_2960, Integer>();
        Matcher matches = regex.matcher(variantId.method_12832());
        if (!matches.matches()) {
            VariantsCitMod.LOGGER.warn("Not a valid enchantment set: {}", variantId.method_12832());
            return Optional.empty();
        }
        matches.reset();
        while (matches.find()) {
            String path = matches.group("path");
            String namespace = Optional.ofNullable(matches.group("namespace")).orElse("minecraft");
            int level = Optional.ofNullable(matches.group("lvl")).map(Integer::parseInt).orElse(1);
            class_2960 enchantId = class_2960.method_60655((String)namespace, (String)path);
            if (vector.containsKey(enchantId = aliases.getOrDefault(enchantId, enchantId))) {
                VariantsCitMod.LOGGER.warn("Duplicate enchantment '{}' in set: {}", enchantId, variantId.method_12832());
                return Optional.empty();
            }
            if (level == 0) {
                VariantsCitMod.LOGGER.warn("Level 0 enchantments have no effect. {}", variantId.method_12832());
            }
            vector.put(enchantId, level);
        }
        return Optional.of(vector);
    }

    private static Pattern BakeRegex(String enchantSeparator, Optional<String> levelSeparator, Boolean optionalLevel) {
        String enchantSep = enchantSeparator;
        String lvlSep = levelSeparator.orElse("");
        Object lvlRegex = levelSeparator.isPresent() || optionalLevel != false ? lvlSep + "(?<lvl>[0-9]+)" : "(?<lvl>)";
        if (optionalLevel.booleanValue()) {
            lvlRegex = "(?:" + (String)lvlRegex + ")?";
        }
        String regex = "(?<=^|." + enchantSep + ")(?:(?<namespace>[a-z0-9_.-]*?)\\.\\.)?(?<path>[a-z0-9_.-]+?)" + (String)lvlRegex + "(?=" + enchantSep + ".+|$)";
        return Pattern.compile(regex);
    }

    private static DataResult<String> ValidateSeparator(String raw) {
        if (!raw.matches("^[a-z0-9_.-/]*$")) {
            return DataResult.error(() -> "Separator contains invalid characters: " + raw);
        }
        return DataResult.success((Object)raw.replace(".", "\\."));
    }

    @Override
    public class_2960 GetModelForItem(class_1799 stack) {
        return this.cache.ComputeIfAbsent(stack, this::ComputeItemModel);
    }

    public class_2960 ComputeItemModel(class_1799 stack) {
        class_9304 enchants = (class_9304)stack.method_58694(this.componentType);
        if (enchants == null || enchants.method_57543()) {
            return null;
        }
        EnchantVector enchantBox = this.vectorSpace.TruncatedVectorFromComponent(enchants);
        VariantEntry result = this.modelLine.GetClosestValue(this.magnitudeGetter.applyAsInt(enchantBox), -1, variant -> variant.vector.IsWithin(enchantBox));
        return result != null ? result.modelId : this.fallback;
    }

    public record Parameters(boolean bakingDebug, boolean runtimeDebug, List<ToIntFunction<EnchantVector>> ordering, Pattern vectorRegex, Map<class_2960, class_2960> aliases, String namespace) {
    }

    private static class VectorSpace {
        private final Object2IntMap<class_2960> indices;
        private final EnchantVector maxLevels;

        public VectorSpace(Map<class_2960, Integer> maxLevels) {
            this.indices = new Object2IntOpenHashMap(maxLevels.size());
            int i = 0;
            for (Map.Entry<class_2960, Integer> entry : maxLevels.entrySet()) {
                this.indices.put((Object)entry.getKey(), i++);
            }
            this.maxLevels = this.VectorFromMap(maxLevels);
        }

        public EnchantVector TruncatedVectorFromComponent(class_9304 enchants) {
            EnchantVector vector = new EnchantVector(this.indices.size());
            for (Object2IntMap.Entry entry : enchants.method_57539()) {
                int i = this.indices.getOrDefault((Object)((class_5321)((class_6880)entry.getKey()).method_40230().get()).method_29177(), -1);
                if (i < 0) continue;
                vector.values[i] = Math.min(entry.getIntValue(), this.maxLevels.values[i]);
            }
            return vector;
        }

        public EnchantVector VectorFromMap(Map<class_2960, Integer> enchants) {
            EnchantVector vector = new EnchantVector(this.indices.size());
            for (Map.Entry<class_2960, Integer> entry : enchants.entrySet()) {
                int i = this.indices.getOrDefault((Object)entry.getKey(), -1);
                if (i < 0) continue;
                vector.values[i] = entry.getValue();
            }
            return vector;
        }
    }

    private static class EnchantVector {
        public final int[] values;

        public EnchantVector(int size) {
            this.values = new int[size];
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }

        public boolean equals(Object other) {
            EnchantVector vec;
            return other instanceof EnchantVector && this.equals(vec = (EnchantVector)other);
        }

        public boolean equals(EnchantVector other) {
            return Arrays.equals(this.values, other.values);
        }

        public int TaxicabMagnitude() {
            int magnitude = 0;
            for (int i : this.values) {
                magnitude += i;
            }
            return magnitude;
        }

        public int EuclidianSquaredMagnitude() {
            int magnitude = 0;
            for (int i : this.values) {
                magnitude += i * i;
            }
            return magnitude;
        }

        public int Maximum() {
            int magnitude = 0;
            for (int i : this.values) {
                if (i <= magnitude) continue;
                magnitude = i;
            }
            return magnitude;
        }

        public int Dimensionality() {
            int dimensions = 0;
            for (int i : this.values) {
                if (i == 0) continue;
                ++dimensions;
            }
            return dimensions;
        }

        public boolean IsWithin(EnchantVector box) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] <= box.values[i]) continue;
                return false;
            }
            return true;
        }
    }

    public record VariantEntry(EnchantVector vector, class_2960 modelId) {
    }
}

